/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.search;

import fitnesse.components.TraversalListener;
import fitnesse.wiki.NoPruningStrategy;
import fitnesse.wiki.SymbolicPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperty;
import fitnesse.wiki.WikiSourcePage;
import fitnesse.wiki.WikiWordReference;
import fitnesse.wiki.search.PageFinder;
import fitnesse.wikitext.MarkUpSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class WhereUsedPageFinder
implements TraversalListener<WikiPage>,
PageFinder {
    private final WikiPage subjectPage;
    private final TraversalListener<? super WikiPage> observer;
    private WikiPage currentPage;
    private final List<WikiPage> hits = new ArrayList<WikiPage>();

    public WhereUsedPageFinder(WikiPage subjectPage, TraversalListener<? super WikiPage> observer) {
        this.subjectPage = subjectPage;
        this.observer = observer;
    }

    @Override
    public void process(WikiPage currentPage) {
        this.currentPage = currentPage;
        this.checkSymbolicLinks();
        if (!this.hits.contains(currentPage)) {
            this.checkContent();
        }
    }

    private void checkSymbolicLinks() {
        WikiPageProperty suiteProperty = this.currentPage.getData().getProperties().getProperty("SymbolicLinks");
        if (suiteProperty != null) {
            Set<String> links = suiteProperty.keySet();
            for (String link : links) {
                WikiPage linkTarget = this.currentPage.getChildPage(link);
                if (!(linkTarget instanceof SymbolicPage) || !((SymbolicPage)linkTarget).getRealPage().equals(this.subjectPage)) continue;
                this.addHit();
                break;
            }
        }
    }

    private void checkContent() {
        MarkUpSystem.make().findWhereUsed(new WikiSourcePage(this.currentPage), name -> {
            WikiPage referencedPage = new WikiWordReference(this.currentPage, (String)name).getReferencedPage();
            if (referencedPage != null && referencedPage.equals(this.subjectPage)) {
                this.addHit();
            }
        });
    }

    @Override
    public void search(WikiPage page) {
        this.hits.clear();
        page.getPageCrawler().traverse(this, new NoPruningStrategy());
    }

    private void addHit() {
        if (this.hits.contains(this.currentPage)) {
            return;
        }
        this.hits.add(this.currentPage);
        this.observer.process(this.currentPage);
    }
}

