/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext;

import fitnesse.wikitext.CompositeVariableSource;
import fitnesse.wikitext.SourcePage;
import fitnesse.wikitext.VariableSource;
import fitnesse.wikitext.VariableStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ParsingPage
implements VariableStore {
    private final SourcePage page;
    private final SourcePage namedPage;
    private final VariableSource variableSource;
    private final Cache cache;

    public ParsingPage(SourcePage page) {
        this(page, new Cache());
    }

    private ParsingPage(SourcePage page, Cache cache) {
        this(page, page, cache, cache);
    }

    public ParsingPage(SourcePage page, VariableSource variableSource, Cache cache) {
        this(page, page, variableSource, cache);
    }

    private ParsingPage(SourcePage page, SourcePage namedPage, VariableSource variableSource, Cache cache) {
        this.page = page;
        this.namedPage = namedPage;
        this.variableSource = new CompositeVariableSource(new NamedPageVariableSource(namedPage), variableSource);
        this.cache = cache;
    }

    public ParsingPage copyForNamedPage(SourcePage namedPage) {
        return new ParsingPage(this.page, namedPage, this.variableSource, this.cache);
    }

    public SourcePage getPage() {
        return this.page;
    }

    public SourcePage getNamedPage() {
        return this.namedPage;
    }

    @Override
    public int nextId() {
        return this.cache.nextId();
    }

    @Override
    public void putVariable(String name, String value) {
        this.cache.putVariable(name, value);
    }

    @Override
    public Optional<String> findVariable(String name) {
        return this.variableSource != null ? this.variableSource.findVariable(name) : Optional.empty();
    }

    private static class NamedPageVariableSource
    implements VariableSource {
        private final SourcePage namedPage;

        private NamedPageVariableSource(SourcePage namedPage) {
            this.namedPage = namedPage;
        }

        @Override
        public Optional<String> findVariable(String key) {
            String value;
            if (key.equals("PAGE_NAME")) {
                value = this.namedPage.getName();
            } else if (key.equals("PAGE_PATH")) {
                value = this.namedPage.getPath();
            } else {
                return Optional.empty();
            }
            return Optional.ofNullable(value);
        }
    }

    public static class Cache
    implements VariableStore {
        private final Map<String, String> cache;
        private int id;

        public Cache() {
            this(new HashMap<String, String>());
        }

        public Cache(Map<String, String> cache) {
            this.cache = cache;
        }

        @Override
        public void putVariable(String name, String value) {
            this.cache.put(name, value);
        }

        @Override
        public Optional<String> findVariable(String name) {
            return Optional.ofNullable(this.cache.get(name));
        }

        @Override
        public int nextId() {
            return this.id++;
        }
    }
}

