/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Maybe;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import fitnesse.wikitext.shared.ContentsItemBuilder;

public class Contents
extends SymbolType
implements Rule,
Translation {
    public Contents() {
        super("Contents");
        this.wikiMatcher(new Matcher().startLineOrCell().string("!contents"));
        this.wikiRule(this);
        this.htmlTranslation(this);
    }

    @Override
    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        Symbol body = parser.parseToEnd(SymbolType.Newline);
        for (Symbol child : body.getChildren()) {
            if (child.isType(SymbolType.Whitespace)) continue;
            String option = child.getContent();
            if (!option.startsWith("-")) {
                return Symbol.nothing;
            }
            if (option.equals("-R")) {
                current.putProperty(option, String.valueOf(Integer.MAX_VALUE));
                continue;
            }
            if (option.startsWith("-R")) {
                current.putProperty("-R", option.substring(2));
                continue;
            }
            current.putProperty(option, "");
        }
        current.copyVariables(new String[]{"HELP_TOC", "HELP_INSTEAD_OF_TITLE_TOC", "REGRACE_TOC", "PROPERTY_TOC", "FILTER_TOC", "MORE_SUFFIX_TOC", "PROPERTY_CHARACTERS", "TEST_PAGE_COUNT_TOC"}, parser.getVariableSource());
        return new Maybe<Symbol>(current);
    }

    @Override
    public String toTarget(Translator translator, Symbol symbol) {
        ContentsItemBuilder itemBuilder = new ContentsItemBuilder(symbol, 1, translator.getPage());
        HtmlTag contentsDiv = new HtmlTag("div");
        contentsDiv.addAttribute("class", "contents");
        contentsDiv.add(HtmlUtil.makeBold("Contents:"));
        contentsDiv.add(itemBuilder.buildLevel(translator.getPage()));
        return contentsDiv.html();
    }
}

