/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.html.HtmlElement;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.wikitext.parser.HeaderLine;
import fitnesse.wikitext.parser.HtmlTranslator;
import fitnesse.wikitext.parser.Literal;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Maybe;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class Headings
extends SymbolType
implements Rule,
Translation {
    public static final Headings symbolType = new Headings();
    public static final String DEFAULT_STYLE = "decimal";
    private static final String STYLE = "STYLE";
    private static final List<String> LIST_STYLES = new ArrayList<String>(Arrays.asList("decimal", "decimal-leading-zero", "lower-roman", "upper-roman", "lower-alpha", "upper-alpha", "none"));

    public Headings() {
        super("Headings");
        this.wikiMatcher(new Matcher().startLineOrCell().string("!headings"));
        this.wikiRule(this);
        this.htmlTranslation(this);
    }

    @Override
    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        Symbol body = parser.parseToEnd(SymbolType.Newline);
        if (body.getChildren().size() > 3 && body.childAt(0).getType() == SymbolType.Whitespace && body.childAt(1).getType() == SymbolType.Text && body.childAt(1).getContent().equalsIgnoreCase("-STYLE") && body.childAt(2).getType() == SymbolType.Whitespace && body.childAt(3).getType() == SymbolType.Text) {
            current.putProperty(STYLE, body.childAt(3).getContent());
        }
        return new Maybe<Symbol>(current);
    }

    @Override
    public String toTarget(Translator translator, Symbol current) {
        String style = current.findProperty(STYLE, DEFAULT_STYLE);
        List<Symbol> headerLines = this.findHeaderLines(((HtmlTranslator)translator).getSyntaxTree());
        HeadingContentBuilder headingContentBuilder = new HeadingContentBuilder(headerLines, LIST_STYLES.contains(style) ? style : DEFAULT_STYLE);
        HtmlElement html = headingContentBuilder.htmlElements();
        return html.html();
    }

    private List<Symbol> findHeaderLines(Symbol tree) {
        LinkedList<Symbol> symbols = new LinkedList<Symbol>();
        for (Symbol symbol : tree.getChildren()) {
            if (!symbol.isType(HeaderLine.symbolType)) continue;
            symbols.add(symbol);
        }
        return Collections.unmodifiableList(symbols);
    }

    static String extractTextFromHeaderLine(Symbol headerLine) {
        StringBuilder sb = new StringBuilder();
        headerLine.walkPreOrder(node -> {
            if (node.isType(SymbolType.Text) || node.isType(Literal.symbolType) || node.isType(Whitespace)) {
                sb.append(node.getContent());
            }
        });
        return sb.toString();
    }

    class HeadingContentBuilder {
        private final List<Symbol> headerLines;
        private final Stack<HtmlTag> stack = new Stack();
        private final String listStyle;
        private final HtmlTag rootElement;
        private boolean processed;

        HeadingContentBuilder(List<Symbol> headerLines, String listStyle) {
            this.headerLines = headerLines;
            this.listStyle = listStyle;
            this.rootElement = new HtmlTag("div");
            this.rootElement.addAttribute("class", "contents");
            this.rootElement.add(HtmlUtil.makeBold("Contents:"));
            this.stack.push(this.rootElement);
        }

        HtmlElement htmlElements() {
            for (Symbol headerLine : this.headerLines) {
                this.processed = false;
                this.htmlElements(headerLine);
            }
            return this.rootElement;
        }

        private void htmlElements(Symbol headerLine) {
            this.addListElement(headerLine);
            this.goToParent(headerLine);
            this.addListItemElement(headerLine);
            if (!this.processed) {
                this.htmlElements(headerLine);
            }
        }

        private void addListElement(Symbol headerLine) {
            if (this.getLevel(headerLine) > this.currentLevel()) {
                HtmlTag listElement = new HtmlTag("ol");
                listElement.addAttribute("style", "list-style-type: " + this.listStyle + ";");
                this.stack.peek().add(listElement);
                this.stack.push(listElement);
            }
        }

        private void goToParent(Symbol headerLine) {
            if (this.getLevel(headerLine) < this.currentLevel()) {
                this.stack.pop();
            }
        }

        private void addListItemElement(Symbol headerLine) {
            if (this.getLevel(headerLine) == this.currentLevel()) {
                HtmlTag listitemElement = new HtmlTag("li");
                listitemElement.addAttribute("class", "heading" + this.currentLevel());
                String textFromHeaderLine = Headings.extractTextFromHeaderLine(headerLine);
                HtmlTag anchorElement = new HtmlTag("a", textFromHeaderLine);
                headerLine.findProperty("id").ifPresent(id -> anchorElement.addAttribute("href", "#" + id));
                listitemElement.add(anchorElement);
                this.stack.peek().add(listitemElement);
                this.processed = true;
            }
        }

        private int currentLevel() {
            return this.stack.size() - 1;
        }

        private int getLevel(Symbol headerLine) {
            return Integer.parseInt(headerLine.findProperty("level", "0"));
        }
    }
}

