/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.html.HtmlTag;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import java.util.ArrayList;
import java.util.List;

public class HtmlBuilder
implements Translation {
    private List<TagBuilder> builders = new ArrayList<TagBuilder>();
    private String tagName;
    private boolean inline;

    public HtmlBuilder(String tagName) {
        this.tagName = tagName;
    }

    public HtmlBuilder inline() {
        this.inline = true;
        return this;
    }

    public HtmlBuilder attribute(final String name, final String value) {
        this.builders.add(new TagBuilder(){

            @Override
            public void build(Translator translator, Symbol symbol, HtmlTag tag) {
                tag.addAttribute(name, value);
            }
        });
        return this;
    }

    public HtmlBuilder attribute(String name, int index) {
        return this.attribute(name, index, "");
    }

    public HtmlBuilder attribute(final String name, final int index, final String prefix) {
        this.builders.add(new TagBuilder(){

            @Override
            public void build(Translator translator, Symbol symbol, HtmlTag tag) {
                tag.addAttribute(name, prefix + (index < 0 ? symbol.getContent() : HtmlBuilder.this.TranslateChildAt(translator, symbol, index)));
            }
        });
        return this;
    }

    public HtmlBuilder body(int index) {
        return this.body(index, "");
    }

    public HtmlBuilder body(final int index, final String prefix) {
        this.builders.add(new TagBuilder(){

            @Override
            public void build(Translator translator, Symbol symbol, HtmlTag tag) {
                tag.add(prefix + HtmlBuilder.this.TranslateChildAt(translator, symbol, index));
            }
        });
        return this;
    }

    private String TranslateChildAt(Translator translator, Symbol symbol, int index) {
        return index < 0 ? "" : translator.translate(symbol.childAt(index));
    }

    @Override
    public String toTarget(Translator translator, Symbol symbol) {
        HtmlTag result = new HtmlTag(this.tagName);
        for (TagBuilder builder : this.builders) {
            builder.build(translator, symbol, result);
        }
        return this.inline ? result.htmlInline() : result.html();
    }

    private static interface TagBuilder {
        public void build(Translator var1, Symbol var2, HtmlTag var3);
    }
}

