/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Link;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Maybe;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import fitnesse.wikitext.parser.WikiWord;
import java.util.Map;
import java.util.TreeMap;

public class Image
extends SymbolType
implements Rule,
Translation {
    public static final Image symbolType = new Image();

    public Image() {
        super("Image");
        this.wikiMatcher(new Matcher().string("!img-l"));
        this.wikiMatcher(new Matcher().string("!img-r"));
        this.wikiMatcher(new Matcher().string("!img"));
        this.wikiRule(this);
        this.htmlTranslation(this);
    }

    @Override
    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        StringBuilder source = new StringBuilder(current.getContent());
        String imageProperty = current.getContent().endsWith("l") ? "left" : (current.getContent().endsWith("r") ? "right" : "");
        parser.moveNext(1);
        if (!parser.getCurrent().isType(SymbolType.Whitespace)) {
            return Symbol.nothing;
        }
        source.append(parser.getCurrent().getContent());
        parser.moveNext(1);
        TreeMap<String, String> options = new TreeMap<String, String>();
        while (parser.getCurrent().isType(SymbolType.Text) && parser.getCurrent().getContent().startsWith("-")) {
            String option = parser.getCurrent().getContent();
            source.append(option);
            parser.moveNext(1);
            if (!parser.getCurrent().isType(SymbolType.Whitespace)) {
                return Symbol.nothing;
            }
            source.append(parser.getCurrent().getContent());
            parser.moveNext(1);
            if (!parser.getCurrent().isType(SymbolType.Text)) {
                return Symbol.nothing;
            }
            source.append(parser.getCurrent().getContent());
            String value = parser.getCurrent().getContent();
            parser.moveNext(1);
            if (!parser.getCurrent().isType(SymbolType.Whitespace)) {
                return Symbol.nothing;
            }
            source.append(parser.getCurrent().getContent());
            parser.moveNext(1);
            options.put(option, value);
        }
        current.setContent(source.toString());
        Symbol name = parser.getCurrent();
        if (name.isType(Link.symbolType)) {
            Maybe<Symbol> link = Link.symbolType.getWikiRule().parse(name, parser);
            if (link.isNothing()) {
                return Symbol.nothing;
            }
            this.addOptions(link.getValue(), options);
            return this.makeImageLink(current, link.getValue(), imageProperty);
        }
        if (name.isType(SymbolType.Text) || name.isType(WikiWord.symbolType)) {
            Symbol list = new Symbol(SymbolType.SymbolList).add(new Symbol(SymbolType.Text, name.getContent()));
            Symbol link = new Symbol(Link.symbolType).add(list);
            this.addOptions(link, options);
            return this.makeImageLink(current, link, imageProperty);
        }
        return Symbol.nothing;
    }

    private void addOptions(Symbol link, Map<String, String> options) {
        for (Map.Entry<String, String> entry : options.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.equals("-w")) {
                link.putProperty("width", value);
            }
            if (key.equals("-m")) {
                link.putProperty("style", String.format("%2$smargin:%1$spx;", value, link.getProperty("style")));
            }
            if (!key.equals("-b")) continue;
            link.putProperty("style", String.format("%2$sborder:%1$spx solid black;", value, link.getProperty("style")));
        }
    }

    private Maybe<Symbol> makeImageLink(Symbol current, Symbol link, String imageProperty) {
        link.putProperty("image", imageProperty);
        return new Maybe<Symbol>(current.add(link));
    }

    @Override
    public String toTarget(Translator translator, Symbol symbol) {
        return translator.translate(symbol.childAt(0));
    }
}

