/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

public class ScanString {
    private final CharSequence input;
    private int offset;
    private int markStartOffset;

    public ScanString(CharSequence input, int offset) {
        this.input = input != null ? input : "";
        this.offset = offset;
    }

    public ScanString(ScanString other) {
        this.input = other.input;
        this.offset = other.offset;
        this.markStartOffset = other.markStartOffset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public void moveNext() {
        ++this.offset;
    }

    public boolean isEnd() {
        return this.isEnd(0);
    }

    public boolean isEnd(int startAt) {
        return this.offset + startAt >= this.input.length();
    }

    public void markStart(int markStartOffset) {
        this.markStartOffset = markStartOffset;
    }

    public boolean matches(String match, int startsAt) {
        if (match.isEmpty()) {
            return false;
        }
        if (this.offset + startsAt + match.length() > this.input.length()) {
            return false;
        }
        return match.equals(this.input.subSequence(this.offset + startsAt, this.offset + startsAt + match.length()).toString());
    }

    public boolean startsWith(String match) {
        return this.matches(match, 0);
    }

    public boolean startsLine(int startAt) {
        return this.offset + startAt == 0 || this.offset + startAt == this.markStartOffset || this.input.charAt(this.offset + startAt - 1) == '\n';
    }

    public int find(char[] matches, int startAt) {
        for (int current = this.offset + startAt; current < this.input.length(); ++current) {
            for (char match : matches) {
                if (this.input.charAt(current) != match) continue;
                return current - this.offset;
            }
        }
        return -1;
    }

    public String substring(int startAt, int endBefore) {
        return this.input.subSequence(this.offset + startAt, this.offset + endBefore).toString();
    }

    public String rawSubstring(int startAt, int endBefore) {
        return this.input.subSequence(startAt, endBefore).toString();
    }

    public String substringFrom(int startAt) {
        return this.input.subSequence(startAt, this.offset).toString();
    }

    public char charAt(int startAt) {
        if (this.offset + startAt >= this.input.length()) {
            return '\u0000';
        }
        return this.input.charAt(this.offset + startAt);
    }

    public int whitespaceLength(int startAt) {
        int current;
        for (current = this.offset + startAt; current < this.input.length() && Character.isWhitespace(this.input.charAt(current)) && this.input.charAt(current) != '\n' && this.input.charAt(current) != '\r'; ++current) {
        }
        return current - this.offset - startAt;
    }

    public static boolean isWord(String content) {
        for (char c : content.toCharArray()) {
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean isDigits(String content) {
        for (char c : content.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isVariableName(String content) {
        for (char c : content.toCharArray()) {
            if (Character.isLetterOrDigit(c) || c == '_' || c == '.') continue;
            return false;
        }
        return true;
    }
}

