/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.util.Tree;
import fitnesse.wikitext.VariableSource;
import fitnesse.wikitext.parser.HeaderLine;
import fitnesse.wikitext.parser.HorizontalRule;
import fitnesse.wikitext.parser.Maybe;
import fitnesse.wikitext.parser.Nesting;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Table;
import fitnesse.wikitext.shared.PropertyStore;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Symbol
extends Tree<Symbol>
implements PropertyStore {
    private static final List<Symbol> NO_CHILDREN = Collections.emptyList();
    public static final Maybe<Symbol> nothing = new Maybe();
    public static final Symbol emptySymbol = new Symbol(SymbolType.Empty);
    private SymbolType type;
    private String content;
    private List<Symbol> branches;
    private Map<String, String> variables;
    private Map<String, String> properties;
    private int startOffset = -1;
    private int endOffset = -1;

    public Symbol(SymbolType type) {
        this(type, "");
    }

    public Symbol(SymbolType type, String content) {
        this.type = type;
        this.content = content;
        this.branches = NO_CHILDREN;
    }

    public Symbol(SymbolType type, String content, int startOffset) {
        this(type, content);
        this.startOffset = startOffset;
        this.endOffset = startOffset + content.length();
    }

    public Symbol(SymbolType type, String content, int startOffset, int endOffset) {
        this(type, content);
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public SymbolType getType() {
        return this.type;
    }

    public boolean isType(SymbolType type) {
        return this.type.matchesFor(type);
    }

    public boolean isStartCell() {
        return this.isType(Table.symbolType) || this.isType(SymbolType.EndCell);
    }

    public boolean isStartLine() {
        return this.isType(HorizontalRule.symbolType) || this.isType(Nesting.symbolType);
    }

    public boolean isLineType() {
        return this.isType(HeaderLine.symbolType) || this.isType(SymbolType.CenterLine) || this.isType(SymbolType.Meta) || this.isType(SymbolType.NoteLine);
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Symbol childAt(int index) {
        return this.getChildren().get(index);
    }

    public Symbol lastChild() {
        return this.childAt(this.getChildren().size() - 1);
    }

    public List<Symbol> getChildren() {
        return this.branches;
    }

    @Override
    protected List<Symbol> getBranches() {
        return this.branches;
    }

    @Override
    protected Symbol getNode() {
        return this;
    }

    @Override
    public Optional<String> findProperty(String key) {
        return this.hasProperty(key) ? Optional.of(this.properties.get(key)) : Optional.empty();
    }

    @Override
    public boolean hasProperty(String key) {
        return this.properties != null && this.properties.containsKey(key);
    }

    @Override
    public void putProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>(1);
        }
        this.properties.put(key, value);
    }

    private List<Symbol> children() {
        if (this.branches == NO_CHILDREN) {
            this.branches = new LinkedList<Symbol>();
        }
        return this.branches;
    }

    public Symbol add(Symbol child) {
        this.children().add(child);
        return this;
    }

    public Symbol add(String text) {
        this.children().add(new Symbol(SymbolType.Text, text));
        return this;
    }

    public Symbol childrenAfter(int after) {
        Symbol result = new Symbol(SymbolType.SymbolList);
        for (int i = after + 1; i < this.branches.size(); ++i) {
            result.add(this.branches.get(i));
        }
        return result;
    }

    @Deprecated
    public void evaluateVariables(String[] names, VariableSource source) {
        if (this.variables == null) {
            this.variables = new HashMap<String, String>(names.length);
        }
        for (String name : names) {
            source.findVariable(name).ifPresent(value -> this.variables.put(name, (String)value));
        }
    }

    @Deprecated
    public String getVariable(String name, String defaultValue) {
        return this.variables != null && this.variables.containsKey(name) ? this.variables.get(name) : defaultValue;
    }

    @Deprecated
    public String getProperty(String key, String defaultValue) {
        return this.findProperty(key, defaultValue);
    }

    @Deprecated
    public String getProperty(String key) {
        return this.findProperty(key, "");
    }

    public boolean hasOffset() {
        return this.startOffset != -1 && this.endOffset != -1;
    }

    Symbol setStartOffset(int startOffset) {
        this.startOffset = startOffset;
        return this;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setType(SymbolType type) {
        this.type = type;
    }
}

