/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Alias;
import fitnesse.wikitext.parser.AnchorName;
import fitnesse.wikitext.parser.AnchorReference;
import fitnesse.wikitext.parser.Collapsible;
import fitnesse.wikitext.parser.Comment;
import fitnesse.wikitext.parser.Contents;
import fitnesse.wikitext.parser.Define;
import fitnesse.wikitext.parser.Evaluator;
import fitnesse.wikitext.parser.HashTable;
import fitnesse.wikitext.parser.HeaderLine;
import fitnesse.wikitext.parser.Headings;
import fitnesse.wikitext.parser.Help;
import fitnesse.wikitext.parser.HorizontalRule;
import fitnesse.wikitext.parser.Image;
import fitnesse.wikitext.parser.Include;
import fitnesse.wikitext.parser.LastModified;
import fitnesse.wikitext.parser.Link;
import fitnesse.wikitext.parser.Literal;
import fitnesse.wikitext.parser.Matchable;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Nesting;
import fitnesse.wikitext.parser.Path;
import fitnesse.wikitext.parser.PlainTextTable;
import fitnesse.wikitext.parser.Preformat;
import fitnesse.wikitext.parser.See;
import fitnesse.wikitext.parser.SymbolMatch;
import fitnesse.wikitext.parser.SymbolMatcher;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Table;
import fitnesse.wikitext.parser.Today;
import fitnesse.wikitext.parser.Variable;
import fitnesse.wikitext.parser.WikiWord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SymbolProvider {
    public static final SymbolProvider refactoringProvider = new SymbolProvider(new SymbolType[]{Alias.symbolType, SymbolType.OpenBracket, SymbolType.CloseBracket, Comment.symbolType, Image.symbolType, Literal.symbolType, Preformat.symbolType, Link.symbolType, Path.symbolType, WikiWord.symbolType, SymbolType.Newline, SymbolType.Whitespace});
    public static final SymbolProvider wikiParsingProvider = new SymbolProvider(new SymbolType[]{Link.symbolType, Table.symbolType, new HashTable(), new HeaderLine(), Literal.symbolType, Nesting.symbolType, new Collapsible(), new AnchorName(), new Contents(), SymbolType.CenterLine, new Define(), new Help(), new Include(), SymbolType.Meta, SymbolType.NoteLine, Path.symbolType, new PlainTextTable(), See.symbolType, SymbolType.Style, new LastModified(), Image.symbolType, new Today(), SymbolType.Delta, new HorizontalRule(), SymbolType.CloseLiteral, SymbolType.Strike, Alias.symbolType, SymbolType.UnorderedList, SymbolType.OrderedList, Comment.symbolType, SymbolType.Whitespace, SymbolType.CloseCollapsible, SymbolType.Newline, SymbolType.Colon, SymbolType.Comma, Evaluator.symbolType, SymbolType.CloseEvaluator, Variable.symbolType, Preformat.symbolType, SymbolType.ClosePreformat, SymbolType.OpenParenthesis, SymbolType.OpenBrace, SymbolType.OpenBracket, SymbolType.CloseNesting, SymbolType.CloseParenthesis, SymbolType.CloseBrace, SymbolType.ClosePlainTextTable, SymbolType.CloseBracket, SymbolType.CloseLiteral, SymbolType.Bold, SymbolType.DateFormatOption, SymbolType.Italic, SymbolType.Strike, new AnchorReference(), WikiWord.symbolType, SymbolType.EMail, SymbolType.Text, new Headings()});
    public static final SymbolProvider noLinksTableParsingProvider = SymbolProvider.copy(wikiParsingProvider).remove(WikiWord.symbolType).remove(SymbolType.EMail).remove(Link.symbolType).add(SymbolType.EndCell);
    public static final SymbolProvider tableParsingProvider = new SymbolProvider(wikiParsingProvider).add(SymbolType.EndCell);
    public static final SymbolProvider aliasLinkProvider = new SymbolProvider(new SymbolType[]{SymbolType.CloseBracket, SymbolType.Whitespace, Evaluator.symbolType, Literal.symbolType, Variable.symbolType});
    public static final SymbolProvider linkTargetProvider = new SymbolProvider(new SymbolType[]{Literal.symbolType, Variable.symbolType});
    public static final SymbolProvider pathRuleProvider = new SymbolProvider(new SymbolType[]{Evaluator.symbolType, Literal.symbolType, Variable.symbolType});
    public static final SymbolProvider literalTableProvider = new SymbolProvider(new SymbolType[]{SymbolType.EndCell, SymbolType.Whitespace, SymbolType.Newline, SymbolType.Colon, Evaluator.symbolType, Literal.symbolType, Variable.symbolType});
    public static final SymbolProvider variableDefinitionSymbolProvider = new SymbolProvider(new SymbolType[]{Literal.symbolType, new Define(), new Include(), SymbolType.CloseLiteral, Comment.symbolType, SymbolType.Whitespace, SymbolType.Newline, Variable.symbolType, Preformat.symbolType, SymbolType.ClosePreformat, SymbolType.Text});
    static final SymbolProvider preformatProvider = new SymbolProvider(new SymbolType[]{SymbolType.ClosePreformat, SymbolType.CloseBrace, SymbolType.CloseLiteral, Literal.symbolType, Variable.symbolType, new Today(), SymbolType.Delta, SymbolType.Whitespace, SymbolType.OpenParenthesis, SymbolType.CloseParenthesis, SymbolType.DateFormatOption, Evaluator.symbolType, SymbolType.CloseEvaluator});
    private static final char defaultMatch = '\u0000';
    private Map<Character, ArrayList<Matchable>> currentDispatch;
    private Collection<SymbolType> symbolTypes = new ArrayList<SymbolType>();
    private SymbolProvider parent = null;

    public static SymbolProvider copy(SymbolProvider provider) {
        return new SymbolProvider(provider.symbolTypes);
    }

    public SymbolProvider(Iterable<SymbolType> types) {
        char c;
        this.currentDispatch = new HashMap<Character, ArrayList<Matchable>>();
        this.currentDispatch.put(Character.valueOf('\u0000'), new ArrayList());
        for (c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
            this.currentDispatch.put(Character.valueOf(c), new ArrayList());
        }
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            this.currentDispatch.put(Character.valueOf(c), new ArrayList());
        }
        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            this.currentDispatch.put(Character.valueOf(c), new ArrayList());
        }
        this.addTypes(types);
    }

    public SymbolProvider(SymbolProvider parent) {
        this(new SymbolType[0]);
        this.parent = parent;
    }

    public SymbolProvider(SymbolType[] types) {
        this(Arrays.asList(types));
    }

    public void addTypes(Iterable<SymbolType> types) {
        for (SymbolType symbolType : types) {
            this.add(symbolType);
        }
    }

    public SymbolProvider add(SymbolType symbolType) {
        if (this.matchesFor(symbolType)) {
            return this;
        }
        this.symbolTypes.add(symbolType);
        for (Matcher matcher : symbolType.getWikiMatchers()) {
            for (char first : matcher.getFirsts()) {
                if (!this.currentDispatch.containsKey(Character.valueOf(first))) {
                    this.currentDispatch.put(Character.valueOf(first), new ArrayList());
                }
                this.currentDispatch.get(Character.valueOf(first)).add(symbolType);
            }
        }
        return this;
    }

    public SymbolProvider remove(SymbolType symbolType) {
        if (!this.matchesFor(symbolType)) {
            return this;
        }
        this.symbolTypes.remove(symbolType);
        for (Matcher matcher : symbolType.getWikiMatchers()) {
            for (char first : matcher.getFirsts()) {
                if (!this.currentDispatch.containsKey(Character.valueOf(first))) {
                    this.currentDispatch.put(Character.valueOf(first), new ArrayList());
                }
                this.currentDispatch.get(Character.valueOf(first)).remove(symbolType);
            }
        }
        return this;
    }

    private List<Matchable> getMatchTypes(Character match) {
        if (this.currentDispatch.containsKey(match)) {
            return this.currentDispatch.get(match);
        }
        return this.currentDispatch.get(Character.valueOf('\u0000'));
    }

    public boolean matchesFor(SymbolType type) {
        return this.parent != null && this.parent.matchesFor(type) || this.symbolTypes.contains(type);
    }

    public SymbolMatch findMatch(Character startCharacter, SymbolMatcher matcher) {
        SymbolMatch parentMatch;
        if (this.parent != null && (parentMatch = this.parent.findMatch(startCharacter, matcher)).isMatch()) {
            return parentMatch;
        }
        for (Matchable candidate : this.getMatchTypes(startCharacter)) {
            SymbolMatch match = matcher.makeMatch(candidate);
            if (!match.isMatch()) continue;
            return match;
        }
        return SymbolMatch.noMatch;
    }
}

