/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wiki.PathParser;
import fitnesse.wikitext.ParsingPage;
import fitnesse.wikitext.SyntaxTree;
import fitnesse.wikitext.parser.Alias;
import fitnesse.wikitext.parser.HtmlTranslator;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.PathsProvider;
import fitnesse.wikitext.parser.See;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.WikiTranslator;
import fitnesse.wikitext.parser.WikiWord;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class SyntaxTreeV2
implements SyntaxTree {
    private final SymbolProvider symbolProvider;
    private Symbol tree;
    private ParsingPage parsingPage;

    public SyntaxTreeV2() {
        this(SymbolProvider.wikiParsingProvider);
    }

    public SyntaxTreeV2(SymbolProvider symbolProvider) {
        this.symbolProvider = symbolProvider;
        this.tree = Symbol.emptySymbol;
    }

    public ParsingPage getParsingPage() {
        return this.parsingPage;
    }

    public Symbol getSyntaxTree() {
        return this.tree;
    }

    public void parse(String input, ParsingPage parsingPage) {
        this.parsingPage = parsingPage;
        this.tree = Parser.make(parsingPage, input, this.symbolProvider).parse();
    }

    public String translateToMarkUp() {
        return new WikiTranslator(this.parsingPage.getPage()).translateTree(this.tree);
    }

    public void findWhereUsed(Consumer<String> takeWhere) {
        this.tree.walkPreOrder(node -> {
            if (node.isType(WikiWord.symbolType)) {
                takeWhere.accept(node.getContent());
            } else if (node.isType(Alias.symbolType)) {
                String linkText = node.childAt(1).childAt(0).getContent();
                if (linkText.contains("?")) {
                    linkText = linkText.substring(0, linkText.indexOf(63));
                }
                takeWhere.accept(linkText);
            }
        });
    }

    public void findReferences(Function<String, Optional<String>> changeReference) {
        this.tree.walkPreOrder(node -> {
            if (node.isType(WikiWord.symbolType)) {
                ((Optional)changeReference.apply(node.getContent())).ifPresent(node::setContent);
            } else if (node.isType(Alias.symbolType)) {
                Symbol wikiWord = node.childAt(0).childAt(0);
                if (wikiWord.isType(WikiWord.symbolType)) {
                    ((Optional)changeReference.apply(wikiWord.getContent())).ifPresent(wikiWord::setContent);
                } else {
                    wikiWord = node.childAt(1).childAt(0);
                    String aliasReference = wikiWord.getContent();
                    if (PathParser.isWikiPath(aliasReference)) {
                        ((Optional)changeReference.apply(aliasReference)).ifPresent(wikiWord::setContent);
                    }
                }
            }
        }, node -> !node.isType(Alias.symbolType));
    }

    @Override
    public String translateToHtml() {
        return new HtmlTranslator(this.parsingPage.getPage(), this).translateTree(this.tree);
    }

    @Override
    public Optional<String> findVariable(String name) {
        return this.parsingPage.findVariable(name);
    }

    @Override
    public void findPaths(Consumer<String> takePath) {
        HtmlTranslator translator = new HtmlTranslator(this.parsingPage.getPage(), this);
        this.tree.walkPostOrder(node -> {
            if (node.getType() instanceof PathsProvider) {
                for (String path : ((PathsProvider)((Object)node.getType())).providePaths(translator, (Symbol)node)) {
                    takePath.accept(path);
                }
            }
        });
    }

    @Override
    public void findXrefs(Consumer<String> takeXref) {
        this.tree.walkPreOrder(node -> {
            if (node.isType(See.symbolType)) {
                if (node.childAt(0).isType(Alias.symbolType)) {
                    takeXref.accept(node.childAt(0).lastChild().childAt(0).getContent());
                } else {
                    takeXref.accept(node.childAt(0).getContent());
                }
            }
        });
    }
}

