/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.util.StringUtils;
import fitnesse.wikitext.parser.HtmlWriter;
import fitnesse.wikitext.parser.Literal;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Maybe;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import fitnesse.wikitext.parser.decorator.SymbolClassPropertyAppender;

public class Table
extends SymbolType
implements Rule,
Translation {
    public static final Table symbolType = new Table();
    public static final SymbolType tableRow = new SymbolType("TableRow");
    public static final SymbolType tableCell = new SymbolType("TableCell");
    static final SymbolType[] cellTerminators = new SymbolType[]{SymbolType.EndCell, SymbolType.Newline};

    public Table() {
        super("Table");
        this.wikiMatcher(new Matcher().startLine().string("|"));
        this.wikiMatcher(new Matcher().startLine().string("!|"));
        this.wikiMatcher(new Matcher().startLine().string("-|"));
        this.wikiMatcher(new Matcher().startLine().string("-!|"));
        this.wikiMatcher(new Matcher().startLine().string("-^|"));
        this.wikiMatcher(new Matcher().startLine().string("^|"));
        this.wikiRule(this);
        this.htmlTranslation(this);
    }

    public Table(String name) {
        super(name);
    }

    @Override
    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        String content = current.getContent();
        if (content.charAt(0) == '-') {
            current.putProperty("hideFirst", "");
        }
        boolean endOfTable = false;
        while (!endOfTable) {
            Symbol row = new Symbol(tableRow);
            row.setStartOffset(parser.getOffset());
            current.add(row);
            do {
                int offset = parser.getOffset();
                Symbol cell = this.parseCell(parser, content);
                if (parser.getOffset() == offset) {
                    endOfTable = true;
                    break;
                }
                if (parser.atEnd()) {
                    return Symbol.nothing;
                }
                if (parser.getCurrent().isType(SymbolType.Newline)) {
                    return Symbol.nothing;
                }
                row.add(cell);
            } while (!this.endsRow(parser.getCurrent()));
            row.setEndOffset(parser.getOffset());
            if (this.startsRow(parser.getCurrent())) continue;
            break;
        }
        return new Maybe<Symbol>(current);
    }

    protected Symbol parseCell(Parser parser, String content) {
        Symbol cell = content.contains("!") ? parser.parseToWithSymbols(cellTerminators, SymbolProvider.literalTableProvider, 1) : (content.contains("^") ? parser.parseToWithSymbols(cellTerminators, SymbolProvider.noLinksTableParsingProvider, 1) : parser.parseToWithSymbols(cellTerminators, SymbolProvider.tableParsingProvider, 1));
        cell.setType(tableCell);
        return cell;
    }

    private boolean endsRow(Symbol symbol) {
        return symbol.getContent().indexOf("\n") > 0;
    }

    private boolean startsRow(Symbol symbol) {
        return symbol.getContent().contains("\n|");
    }

    @Override
    public String toTarget(Translator translator, Symbol table) {
        HtmlWriter writer = new HtmlWriter();
        writer.startTag("table");
        this.writeClassAttributeIfDefinedForSymbol(table, writer);
        int longestRow = this.longestRow(table);
        int rowCount = 0;
        for (Symbol row : table.getChildren()) {
            writer.startTag("tr");
            if (++rowCount == 1 && table.hasProperty("hideFirst")) {
                SymbolClassPropertyAppender.classPropertyAppender().addPropertyValue(row, "hidden");
            }
            this.writeClassAttributeIfDefinedForSymbol(row, writer);
            int extraColumnSpan = longestRow - this.rowLength(row);
            int column = 1;
            for (Symbol cell : row.getChildren()) {
                String body = this.translateCellBody(translator, cell);
                writer.startTag("td");
                if (extraColumnSpan > 0 && column == this.rowLength(row)) {
                    writer.putAttribute("colspan", Integer.toString(extraColumnSpan + 1));
                }
                this.writeClassAttributeIfDefinedForSymbol(cell, writer);
                writer.putText(body);
                writer.endTag();
                ++column;
            }
            writer.endTag();
        }
        writer.endTag();
        return writer.toHtml();
    }

    private void writeClassAttributeIfDefinedForSymbol(Symbol symbol, HtmlWriter writer) {
        if (symbol.hasProperty("class")) {
            writer.putAttribute("class", symbol.getProperty("class"));
        }
    }

    protected String translateCellBody(Translator translator, Symbol cell) {
        String literalDelimiter = new String(new char[]{'\u00ff', '\u0001', '\u00ff'});
        cell.walkPreOrder(node -> {
            if (node.isType(Literal.symbolType)) {
                node.setContent(literalDelimiter + node.getContent() + literalDelimiter);
            }
        });
        return StringUtils.replace(translator.translate(cell).trim(), literalDelimiter, "");
    }

    protected int longestRow(Symbol table) {
        int longest = 0;
        for (Symbol row : table.getChildren()) {
            int length = this.rowLength(row);
            if (length <= longest) continue;
            longest = length;
        }
        return longest;
    }

    protected int rowLength(Symbol row) {
        return row.getChildren().size();
    }
}

