/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import fitnesse.wikitext.shared.PropertySource;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

class Translate
implements Translation {
    private final BiFunction<String[], PropertySource, String> method;
    private final List<Translation> arguments = new ArrayList<Translation>();

    public static Translate with(BiFunction<String[], PropertySource, String> method) {
        return new Translate(method);
    }

    public static Translate with(Function<String[], String> method) {
        return new Translate((strings, source) -> (String)method.apply((String[])strings));
    }

    public static Translate with(Supplier<String> method) {
        return new Translate((strings, source) -> (String)method.get());
    }

    Translate(BiFunction<String[], PropertySource, String> method) {
        this.method = method;
    }

    Translate child(int index) {
        this.arguments.add((translator, symbol) -> translator.translate(symbol.childAt(index)));
        return this;
    }

    Translate content() {
        this.arguments.add((translator, symbol) -> symbol.getContent());
        return this;
    }

    Translate text(String content) {
        this.arguments.add((t, s) -> content);
        return this;
    }

    @Override
    public String toTarget(Translator translator, Symbol symbol) {
        return this.method.apply((String[])this.arguments.stream().map(a -> a.toTarget(translator, symbol)).toArray(String[]::new), symbol);
    }
}

