/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser.decorator;

import fitnesse.testsystems.slim.tables.DecisionTable;
import fitnesse.testsystems.slim.tables.DynamicDecisionTable;
import fitnesse.testsystems.slim.tables.QueryTable;
import fitnesse.testsystems.slim.tables.ScenarioTable;
import fitnesse.testsystems.slim.tables.ScriptTable;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SlimTableFactory;
import fitnesse.wikitext.ParsingPage;
import fitnesse.wikitext.VariableSource;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.Table;
import fitnesse.wikitext.parser.decorator.ParsedSymbolDecorator;
import fitnesse.wikitext.parser.decorator.SymbolClassPropertyAppender;
import fitnesse.wikitext.parser.decorator.SymbolInspector;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class SlimTableDefaultColoring
implements ParsedSymbolDecorator {
    private static final Set<String> SPECIAL_PAGES = new HashSet<String>(Arrays.asList("ScenarioLibrary", "SetUp", "TearDown", "SuiteSetUp", "SuiteTearDown"));
    private static SlimTableDefaultColoring INSTANCE;
    private static boolean isInstalled;
    private final SlimTableFactory sf;

    public static synchronized void createInstanceIfNeeded(SlimTableFactory factory) {
        if (INSTANCE == null) {
            INSTANCE = new SlimTableDefaultColoring(factory);
        }
    }

    public static void install() {
        if (!isInstalled) {
            if (INSTANCE == null) {
                throw new IllegalStateException("No table factory provided yet");
            }
            Table.symbolType.addDecorator(INSTANCE);
            isInstalled = true;
        }
    }

    public static void uninstall() {
        Table.symbolType.removeDecorator(INSTANCE);
        isInstalled = false;
    }

    protected SlimTableDefaultColoring(SlimTableFactory factory) {
        this.sf = factory;
    }

    @Override
    public void handleParsedSymbol(Symbol symbol, VariableSource variableSource) {
        if (this.isSlimContext(variableSource) && this.isOnTestPage(variableSource) || this.isOnSpecialPage(variableSource)) {
            SymbolInspector.inspect(symbol).checkSymbolType(Table.symbolType);
            this.handleParsedTable(symbol);
        }
    }

    private void handleParsedTable(Symbol table) {
        boolean colorTable = false;
        boolean isFirstColumnTitle = false;
        boolean isSecondRowTitle = false;
        int rowNo = 0;
        for (Symbol row : table.getChildren()) {
            ++rowNo;
            List<Symbol> columns = row.getChildren();
            if (columns.isEmpty()) continue;
            Symbol firstCell = columns.get(0);
            String cellContent = SymbolInspector.inspect(firstCell).getRawContent();
            if (rowNo == 1) {
                String lowercaseContent;
                Class<? extends SlimTable> slimTableClazz = this.sf.getTableType(cellContent);
                if (slimTableClazz != null) {
                    colorTable = true;
                    if (DecisionTable.class.isAssignableFrom(slimTableClazz) || DynamicDecisionTable.class.isAssignableFrom(slimTableClazz) || QueryTable.class.isAssignableFrom(slimTableClazz)) {
                        isSecondRowTitle = true;
                    } else if (ScriptTable.class.isAssignableFrom(slimTableClazz) || ScenarioTable.class.isAssignableFrom(slimTableClazz)) {
                        isFirstColumnTitle = true;
                    }
                }
                if (!(colorTable || (lowercaseContent = cellContent.toLowerCase()).equals("comment") || lowercaseContent.startsWith("comment:"))) {
                    colorTable = true;
                    isSecondRowTitle = true;
                }
            }
            if (!colorTable) continue;
            if (rowNo == 1) {
                SymbolClassPropertyAppender.classPropertyAppender().addPropertyValue(row, "slimRowTitle");
                continue;
            }
            if (isSecondRowTitle && rowNo == 2) {
                SymbolClassPropertyAppender.classPropertyAppender().addPropertyValue(row, "slimRowTitle");
                continue;
            }
            if (isFirstColumnTitle) {
                byte[] bodyBytes = cellContent.getBytes();
                int sum = 0;
                for (byte b : bodyBytes) {
                    sum += b;
                }
                SymbolClassPropertyAppender.classPropertyAppender().addPropertyValue(row, "slimRowColor" + sum % 10);
                continue;
            }
            SymbolClassPropertyAppender.classPropertyAppender().addPropertyValue(row, "slimRowColor" + rowNo % 2);
        }
    }

    protected boolean isOnSpecialPage(VariableSource variableSource) {
        if (variableSource instanceof ParsingPage) {
            String name = ((ParsingPage)variableSource).getPage().getName();
            return SPECIAL_PAGES.contains(name);
        }
        return false;
    }

    protected boolean isOnTestPage(VariableSource variableSource) {
        if (variableSource instanceof ParsingPage) {
            return ((ParsingPage)variableSource).getPage().hasProperty("Test");
        }
        return false;
    }

    protected boolean isSlimContext(VariableSource parsingPage) {
        Optional<String> testSystem = parsingPage.findVariable("TEST_SYSTEM");
        return testSystem.isPresent() && "slim".equals(testSystem.get());
    }
}

