/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser.decorator;

import fitnesse.wikitext.parser.Symbol;

public class SymbolClassPropertyAppender {
    public static final String CLASS_PROPERTY_NAME = "class";
    private static final SymbolClassPropertyAppender INSTANCE = new SymbolClassPropertyAppender();

    public static SymbolClassPropertyAppender classPropertyAppender() {
        return INSTANCE;
    }

    private SymbolClassPropertyAppender() {
    }

    public void addPropertyValue(Symbol symbol, String propertyValue) {
        if (symbol.hasProperty(CLASS_PROPERTY_NAME)) {
            String existingValue = symbol.getProperty(CLASS_PROPERTY_NAME);
            if (!this.alreadyContainsValue(existingValue, propertyValue)) {
                this.setPropertyValue(symbol, String.format("%s %s", existingValue, propertyValue));
            }
        } else {
            this.setPropertyValue(symbol, propertyValue);
        }
    }

    private void setPropertyValue(Symbol symbol, String propertyValue) {
        symbol.putProperty(CLASS_PROPERTY_NAME, propertyValue);
    }

    private boolean alreadyContainsValue(String existingValue, String valueToAdd) {
        return this.wrapInSpace(existingValue).contains(this.wrapInSpace(valueToAdd));
    }

    private String wrapInSpace(String existingValue) {
        return String.format(" %s ", existingValue);
    }
}

