/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser.decorator;

import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import java.util.Objects;

public class SymbolInspector {
    private final Symbol symbol;

    private SymbolInspector(Symbol symbol) {
        if (Objects.isNull(symbol)) {
            throw new NullPointerException("Symbol is null");
        }
        this.symbol = symbol;
    }

    public static SymbolInspector inspect(Symbol symbol) {
        return new SymbolInspector(symbol);
    }

    public void checkSymbolType(SymbolType symbolType) {
        if (!symbolType.matchesFor(this.symbol.getType())) {
            throw new IllegalStateException(String.format("Expected symbol of type '%s', but was '%s'", symbolType, this.symbol.getType()));
        }
    }

    public String getRawContent() {
        StringBuilder buffer = new StringBuilder();
        this.symbol.walkPreOrder(node -> buffer.append(node.getContent()));
        return buffer.toString().trim();
    }
}

