/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.shared;

import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.wiki.PageType;
import fitnesse.wiki.WikiSourcePage;
import fitnesse.wikitext.SourcePage;
import fitnesse.wikitext.shared.PropertySource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import util.GracefulNamer;

public class ContentsItemBuilder {
    private final PropertySource contents;
    private final int level;
    private final SourcePage page;
    private static final String PROPERTY_CHARACTERS_DEFAULT = "*+@>-";

    public ContentsItemBuilder(PropertySource contents, int level) {
        this(contents, level, null);
    }

    public ContentsItemBuilder(PropertySource contents, int level, SourcePage page) {
        this.contents = contents;
        this.level = level;
        this.page = page;
    }

    public HtmlTag buildLevel(SourcePage page) {
        HtmlTag list = new HtmlTag("ul");
        list.addAttribute("class", "toc" + this.level);
        for (SourcePage child : this.getSortedChildren(page)) {
            list.add(this.buildListItem(child));
        }
        return list;
    }

    private HtmlTag buildListItem(SourcePage child) {
        HtmlTag listItem = this.buildItem(child);
        if (!child.getChildren().isEmpty()) {
            if (this.level < this.getRecursionLimit()) {
                listItem.add(new ContentsItemBuilder(this.contents, this.level + 1, child).buildLevel(child));
            } else if (this.getRecursionLimit() > 0) {
                listItem.add(this.contents.findProperty("MORE_SUFFIX_TOC", " ..."));
            }
        }
        return listItem;
    }

    private Collection<SourcePage> getSortedChildren(SourcePage parent) {
        ArrayList<SourcePage> result = new ArrayList<SourcePage>(parent.getChildren());
        Collections.sort(result);
        return result;
    }

    public HtmlTag buildItem(SourcePage page) {
        HtmlTag listItem = new HtmlTag("li");
        HtmlTag link = new HtmlTag("a", this.buildBody(page));
        link.addAttribute("href", this.buildReference(page));
        link.addAttribute("class", this.getBooleanPropertiesClasses(page));
        listItem.add(link);
        String help = page.getProperty("Help");
        if (!help.isEmpty()) {
            if (this.hasOption("-h", "HELP_TOC")) {
                listItem.add(HtmlUtil.makeSpanTag("pageHelp", ": " + help));
            } else if (this.hasOption("-H", "HELP_INSTEAD_OF_TITLE_TOC")) {
                link.use(help);
            } else {
                link.addAttribute("title", help);
            }
        }
        return listItem;
    }

    private boolean isSpecialPageToBeCountedAsTest(SourcePage page) {
        String pageName = page.getName();
        return pageName.contains("SuiteSetUp") || pageName.contains("SuiteTearDown");
    }

    private int getTotalTestPagesInASuite(SourcePage page) {
        if (page.hasProperty(PageType.TEST.toString()) || this.isSpecialPageToBeCountedAsTest(page)) {
            return 1;
        }
        int counter = 0;
        if (page.hasProperty(PageType.SUITE.toString())) {
            for (SourcePage sourcePage : page.getChildren()) {
                counter += this.getTotalTestPagesInASuite(sourcePage);
            }
        }
        return counter;
    }

    private String buildBody(SourcePage page) {
        String filters;
        String properties;
        String itemText = page.getName();
        if (this.hasOption("-c", "TEST_PAGE_COUNT_TOC") && page.hasProperty(PageType.SUITE.toString())) {
            itemText = itemText + " ( " + this.getTotalTestPagesInASuite(page) + " )";
        }
        if (this.hasOption("-g", "REGRACE_TOC")) {
            itemText = GracefulNamer.regrace(itemText);
        }
        if (this.hasOption("-p", "PROPERTY_TOC") && !(properties = this.getBooleanProperties(page)).isEmpty()) {
            itemText = itemText + " " + properties;
        }
        if (this.hasOption("-f", "FILTER_TOC") && !(filters = page.getProperty("Suites")).isEmpty()) {
            itemText = itemText + " (" + filters + ")";
        }
        return itemText;
    }

    private String buildReference(SourcePage sourcePage) {
        return sourcePage.getFullName();
    }

    private int getRecursionLimit() {
        String level = this.contents.findProperty("-R", "0");
        try {
            return Integer.parseInt(level);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private boolean hasOption(String option, String variableName) {
        return this.contents.hasProperty(option) || !variableName.isEmpty() && this.contents.findProperty(variableName, "").equals("true");
    }

    private String getBooleanProperties(SourcePage sourcePage) {
        String propChars = this.contents.findProperty("PROPERTY_CHARACTERS", PROPERTY_CHARACTERS_DEFAULT).trim();
        if (propChars.length() != PROPERTY_CHARACTERS_DEFAULT.length()) {
            propChars = PROPERTY_CHARACTERS_DEFAULT;
        }
        String result = "";
        if (sourcePage.hasProperty(PageType.SUITE.toString())) {
            result = result + propChars.charAt(0);
        }
        if (sourcePage.hasProperty(PageType.TEST.toString())) {
            result = result + propChars.charAt(1);
        }
        if (sourcePage.hasProperty("WikiImport")) {
            result = result + propChars.charAt(2);
        }
        if (this.page != null && this.page instanceof WikiSourcePage && ((WikiSourcePage)this.page).hasSymbolicLinkChild(sourcePage.getName())) {
            result = result + propChars.charAt(3);
        }
        if (sourcePage.hasProperty("Prune")) {
            result = result + propChars.charAt(4);
        }
        return result;
    }

    private String getBooleanPropertiesClasses(SourcePage sourcePage) {
        String result = "";
        result = sourcePage.hasProperty(PageType.SUITE.toString()) ? result + "suite" : (sourcePage.hasProperty(PageType.TEST.toString()) ? result + "test" : result + "static");
        if (sourcePage.hasProperty("WikiImport")) {
            result = result + " linked";
        }
        if (sourcePage.hasProperty("Prune")) {
            result = result + " pruned";
        }
        return result;
    }
}

