/*
 * Decompiled with CFR 0.152.
 */
package fitnesseMain;

import fitnesse.ConfigurationParameter;
import fitnesse.ContextConfigurator;
import fitnesse.FitNesse;
import fitnesse.FitNesseContext;
import fitnesse.components.PluginsClassLoaderFactory;
import fitnesse.reporting.ExitCodeListener;
import fitnesse.socketservice.PlainServerSocketFactory;
import fitnesse.socketservice.SslParameters;
import fitnesse.socketservice.SslServerSocketFactory;
import fitnesse.updates.WikiContentUpdater;
import fitnesseMain.Arguments;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class FitNesseMain {
    private static final Logger LOG = Logger.getLogger(FitNesseMain.class.getName());
    private final ExitCodeListener exitCodeListener = new ExitCodeListener();

    public static void main(String[] args) {
        Integer exitCode;
        Arguments arguments = null;
        try {
            arguments = new Arguments(args);
        }
        catch (IllegalArgumentException e) {
            Arguments.printUsage();
            FitNesseMain.exit(1);
        }
        try {
            exitCode = new FitNesseMain().launchFitNesse(arguments);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error while starting the FitNesse", e);
            exitCode = 1;
        }
        if (exitCode != null) {
            FitNesseMain.exit(exitCode);
        }
    }

    protected static void exit(int exitCode) {
        System.exit(exitCode);
    }

    public Integer launchFitNesse(Arguments arguments) throws Exception {
        ContextConfigurator contextConfigurator = ContextConfigurator.systemDefaults();
        contextConfigurator = contextConfigurator.updatedWith(System.getProperties());
        contextConfigurator = contextConfigurator.updatedWith(ConfigurationParameter.loadProperties(new File(arguments.getConfigFile(contextConfigurator))));
        contextConfigurator = arguments.update(contextConfigurator);
        return this.launchFitNesse(contextConfigurator);
    }

    public Integer launchFitNesse(ContextConfigurator contextConfigurator) throws Exception {
        FitNesseContext context;
        this.configureLogging("verbose".equalsIgnoreCase(contextConfigurator.get(ConfigurationParameter.LOG_LEVEL)));
        ClassLoader classLoader = PluginsClassLoaderFactory.getClassLoader(contextConfigurator.get(ConfigurationParameter.ROOT_PATH));
        contextConfigurator.withClassLoader(classLoader);
        if (contextConfigurator.get(ConfigurationParameter.COMMAND) != null) {
            contextConfigurator.withTestSystemListener(this.exitCodeListener);
        }
        if (!this.establishRequiredDirectories((context = contextConfigurator.makeFitNesseContext()).getRootPagePath())) {
            LOG.severe("FitNesse cannot be started...");
            LOG.severe("Unable to create FitNesse root directory in " + context.getRootPagePath());
            LOG.severe("Ensure you have sufficient permissions to create this folder.");
            return 1;
        }
        this.logStartupInfo(context);
        if (this.update(context)) {
            LOG.info("**********************************************************");
            LOG.info("Files have been updated to a new version.");
            LOG.info("Please read the release notes on ");
            LOG.info("http://localhost:" + context.port + "/FitNesse.ReleaseNotes");
            LOG.info("to find out about the new features and fixes.");
            LOG.info("**********************************************************");
        }
        if ("true".equalsIgnoreCase(contextConfigurator.get(ConfigurationParameter.INSTALL_ONLY))) {
            return null;
        }
        try {
            return this.launch(context, classLoader);
        }
        catch (BindException e) {
            LOG.severe("FitNesse cannot be started...");
            LOG.severe("Port " + context.port + " is already in use.");
            LOG.severe("Use the -p <port#> command line argument to use a different port.");
            return 1;
        }
    }

    private boolean establishRequiredDirectories(String rootPagePath) {
        return FitNesseMain.establishDirectory(new File(rootPagePath)) && FitNesseMain.establishDirectory(new File(rootPagePath, "files"));
    }

    private static boolean establishDirectory(File path) {
        return path.exists() || path.mkdir();
    }

    private boolean update(FitNesseContext context) throws IOException {
        if (!"true".equalsIgnoreCase(context.getProperty(ConfigurationParameter.OMITTING_UPDATES.getKey()))) {
            WikiContentUpdater updater = new WikiContentUpdater(context);
            return updater.update();
        }
        return false;
    }

    private Integer launch(FitNesseContext context, ClassLoader classLoader) throws Exception {
        if (!"true".equalsIgnoreCase(context.getProperty(ConfigurationParameter.INSTALL_ONLY.getKey()))) {
            String command = context.getProperty(ConfigurationParameter.COMMAND.getKey());
            if (command != null) {
                String output = context.getProperty(ConfigurationParameter.OUTPUT.getKey());
                this.executeSingleCommand(context.fitNesse, command, output);
                return this.exitCodeListener.getFailCount();
            }
            if ("true".equalsIgnoreCase(context.getProperty(ConfigurationParameter.LOCALHOST_ONLY.getKey()))) {
                LOG.info("Starting FitNesse on port: " + context.port + " (loopback only)");
            } else {
                LOG.info("Starting FitNesse on port: " + context.port);
            }
            ServerSocket serverSocket = this.createServerSocket(context, classLoader);
            context.fitNesse.start(serverSocket);
        }
        return null;
    }

    private ServerSocket createServerSocket(FitNesseContext context, ClassLoader classLoader) throws IOException {
        String protocol = context.getProperty("wiki.protocol");
        boolean useHTTPS = protocol != null && protocol.equalsIgnoreCase("https");
        String clientAuth = context.getProperty("wiki.protocol.ssl.client.auth");
        boolean sslClientAuth = clientAuth != null && clientAuth.equalsIgnoreCase("required");
        String sslParameterClassName = context.getProperty("wiki.protocol.ssl.parameter.class");
        if ("true".equalsIgnoreCase(context.getProperty(ConfigurationParameter.LOCALHOST_ONLY.getKey()))) {
            return (useHTTPS ? new SslServerSocketFactory(sslClientAuth, SslParameters.createSslParameters(sslParameterClassName, classLoader)) : new PlainServerSocketFactory()).createLocalOnlyServerSocket(context.port);
        }
        return (useHTTPS ? new SslServerSocketFactory(sslClientAuth, SslParameters.createSslParameters(sslParameterClassName, classLoader)) : new PlainServerSocketFactory()).createServerSocket(context.port);
    }

    private void executeSingleCommand(FitNesse fitNesse, String command, String outputFile) throws Exception {
        OutputStream os;
        boolean outputRedirectedToFile;
        LOG.info("Executing command: " + command);
        boolean bl = outputRedirectedToFile = outputFile != null;
        if (outputRedirectedToFile) {
            LOG.info("Command Output redirected to: " + outputFile);
            os = new FileOutputStream(outputFile);
        } else {
            os = System.out;
        }
        fitNesse.executeSingleCommand(command, os);
        fitNesse.stop();
        if (outputRedirectedToFile) {
            ((OutputStream)os).close();
        }
    }

    private void logStartupInfo(FitNesseContext context) {
        System.out.println("Bootstrapping FitNesse, the fully integrated standalone wiki and acceptance testing framework.");
        LOG.info("root page: " + context.getRootPage());
        LOG.info("logger: " + (context.logger == null ? "none" : context.logger.toString()));
        LOG.info("authenticator: " + context.authenticator);
        LOG.info("page factory: " + context.pageFactory);
        LOG.info("page theme: " + context.pageFactory.getTheme());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureLogging(boolean verbose) {
        if (this.loggingSystemPropertiesDefined()) {
            return;
        }
        InputStream in = FitNesseMain.class.getResourceAsStream((verbose ? "verbose-" : "") + "logging.properties");
        try {
            LogManager.getLogManager().readConfiguration(in);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Log configuration failed", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Unable to close Log configuration file", e);
                }
            }
        }
        LOG.finest("Configured verbose logging");
    }

    private boolean loggingSystemPropertiesDefined() {
        return System.getProperty("java.util.logging.config.class") != null || System.getProperty("java.util.logging.config.file") != null;
    }
}

