/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flinkx.api;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.Configuration;
import org.apache.flinkx.api.StreamExecutionEnvironment;
import org.apache.flinkx.api.typeinfo.FailFastTypeInfoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Either;
import scala.util.Try$;

public final class StreamExecutionEnvironment$ {
    public static final StreamExecutionEnvironment$ MODULE$ = new StreamExecutionEnvironment$();
    private static transient Logger log;
    private static boolean isFailFastOnScalaTypeResolutionWithClassDisabled;
    private static boolean isFailFastOnScalaTypeResolutionWithClassConfigured;
    private static volatile boolean bitmap$0;
    private static volatile transient boolean bitmap$trans$0;

    static {
        isFailFastOnScalaTypeResolutionWithClassConfigured = false;
    }

    private Logger log$lzycompute() {
        StreamExecutionEnvironment$ streamExecutionEnvironment$ = this;
        synchronized (streamExecutionEnvironment$) {
            if (!bitmap$trans$0) {
                log = LoggerFactory.getLogger(StreamExecutionEnvironment.class);
                bitmap$trans$0 = true;
            }
        }
        return log;
    }

    public Logger log() {
        if (!bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return log;
    }

    @PublicEvolving
    public void setDefaultLocalParallelism(int parallelism) {
        org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.setDefaultLocalParallelism((int)parallelism);
    }

    @PublicEvolving
    public int getDefaultLocalParallelism() {
        return org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.getDefaultLocalParallelism();
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        this.configureExtra();
        return new StreamExecutionEnvironment(org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.getExecutionEnvironment());
    }

    public StreamExecutionEnvironment getExecutionEnvironment(Configuration configuration) {
        this.configureExtra();
        return new StreamExecutionEnvironment(org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.getExecutionEnvironment((Configuration)configuration));
    }

    public StreamExecutionEnvironment createLocalEnvironment(int parallelism) {
        this.configureExtra();
        return new StreamExecutionEnvironment((org.apache.flink.streaming.api.environment.StreamExecutionEnvironment)org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.createLocalEnvironment((int)parallelism));
    }

    public StreamExecutionEnvironment createLocalEnvironment(int parallelism, Configuration configuration) {
        this.configureExtra();
        return new StreamExecutionEnvironment((org.apache.flink.streaming.api.environment.StreamExecutionEnvironment)org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.createLocalEnvironment((int)parallelism, (Configuration)configuration));
    }

    public int createLocalEnvironment$default$1() {
        return org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.getDefaultLocalParallelism();
    }

    @PublicEvolving
    public StreamExecutionEnvironment createLocalEnvironmentWithWebUI(Configuration config) {
        this.configureExtra();
        Configuration conf = config == null ? new Configuration() : config;
        return new StreamExecutionEnvironment(org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.createLocalEnvironmentWithWebUI((Configuration)conf));
    }

    public Configuration createLocalEnvironmentWithWebUI$default$1() {
        return null;
    }

    public StreamExecutionEnvironment createRemoteEnvironment(String host, int port, Seq<String> jarFiles) {
        this.configureExtra();
        return new StreamExecutionEnvironment(org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.createRemoteEnvironment((String)host, (int)port, (String[])((String[])jarFiles.toArray(ClassTag$.MODULE$.apply(String.class)))));
    }

    public StreamExecutionEnvironment createRemoteEnvironment(String host, int port, int parallelism, Seq<String> jarFiles) {
        this.configureExtra();
        org.apache.flink.streaming.api.environment.StreamExecutionEnvironment javaEnv = org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.createRemoteEnvironment((String)host, (int)port, (String[])((String[])jarFiles.toArray(ClassTag$.MODULE$.apply(String.class))));
        javaEnv.setParallelism(parallelism);
        return new StreamExecutionEnvironment(javaEnv);
    }

    public StreamExecutionEnvironment createRemoteEnvironment(String host, int port, Configuration config, Seq<String> jarFiles) {
        this.configureExtra();
        org.apache.flink.streaming.api.environment.StreamExecutionEnvironment javaEnv = org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.createRemoteEnvironment((String)host, (int)port, (Configuration)config, (String[])((String[])jarFiles.toArray(ClassTag$.MODULE$.apply(String.class))));
        return new StreamExecutionEnvironment(javaEnv);
    }

    private void configureExtra() {
        if (!this.isFailFastOnScalaTypeResolutionWithClassConfigured() && !this.isFailFastOnScalaTypeResolutionWithClassDisabled()) {
            this.isFailFastOnScalaTypeResolutionWithClassConfigured_$eq(true);
            try {
                Class<?> typeExtractorClass = Class.forName("org.apache.flink.api.java.typeutils.TypeExtractor");
                Method registerFactoryMethod = typeExtractorClass.getMethod("registerFactory", Type.class, Class.class);
                registerFactoryMethod.invoke(null, Product.class, FailFastTypeInfoFactory.class);
                registerFactoryMethod.invoke(null, Option.class, FailFastTypeInfoFactory.class);
                registerFactoryMethod.invoke(null, Either.class, FailFastTypeInfoFactory.class);
                registerFactoryMethod.invoke(null, Iterable.class, FailFastTypeInfoFactory.class);
            }
            catch (Throwable t) {
                this.log().info(new StringBuilder(103).append("Unable to activate 'fail-fast on Scala type resolution with Class' feature: available from Flink 1.19: ").append(t).toString());
            }
            return;
        }
    }

    private boolean isFailFastOnScalaTypeResolutionWithClassConfigured() {
        return isFailFastOnScalaTypeResolutionWithClassConfigured;
    }

    private void isFailFastOnScalaTypeResolutionWithClassConfigured_$eq(boolean x$1) {
        isFailFastOnScalaTypeResolutionWithClassConfigured = x$1;
    }

    private boolean isFailFastOnScalaTypeResolutionWithClassDisabled$lzycompute() {
        StreamExecutionEnvironment$ streamExecutionEnvironment$ = this;
        synchronized (streamExecutionEnvironment$) {
            if (!bitmap$0) {
                isFailFastOnScalaTypeResolutionWithClassDisabled = package$.MODULE$.env().get((Object)"DISABLE_FAIL_FAST_ON_SCALA_TYPE_RESOLUTION_WITH_CLASS").exists((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)StreamExecutionEnvironment$.$anonfun$isFailFastOnScalaTypeResolutionWithClassDisabled$1(v)));
                bitmap$0 = true;
            }
        }
        return isFailFastOnScalaTypeResolutionWithClassDisabled;
    }

    private boolean isFailFastOnScalaTypeResolutionWithClassDisabled() {
        if (!bitmap$0) {
            return this.isFailFastOnScalaTypeResolutionWithClassDisabled$lzycompute();
        }
        return isFailFastOnScalaTypeResolutionWithClassDisabled;
    }

    public static final /* synthetic */ boolean $anonfun$isFailFastOnScalaTypeResolutionWithClassDisabled$1(String v) {
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(v))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    private StreamExecutionEnvironment$() {
    }
}

