/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.typeutils;

import java.io.Serializable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializerBase;
import org.apache.flink.streaming.util.typeutils.FieldAccessor;
import org.apache.flink.streaming.util.typeutils.ScalaProductFieldAccessorFactory;
import org.apache.flink.util.Preconditions;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class DefaultScalaProductFieldAccessorFactory
implements ScalaProductFieldAccessorFactory,
Serializable {
    public <T, F> FieldAccessor<T, F> createSimpleProductFieldAccessor(int pos, TypeInformation<T> typeInfo, ExecutionConfig config) {
        return new SimpleProductFieldAccessor(this, pos, typeInfo, config);
    }

    public <T, R, F> FieldAccessor<T, F> createRecursiveProductFieldAccessor(int pos, TypeInformation<T> typeInfo, FieldAccessor<R, F> innerAccessor, ExecutionConfig config) {
        return new RecursiveProductFieldAccessor<T, R, F>(this, pos, typeInfo, innerAccessor, config);
    }

    public final class RecursiveProductFieldAccessor<T, R, F>
    extends FieldAccessor<T, F> {
        private static final long serialVersionUID = 1L;
        private final int pos;
        private final FieldAccessor innerAccessor;
        private final TupleSerializerBase<T> serializer;
        private final int length;
        private final Object[] fields;
        private final /* synthetic */ DefaultScalaProductFieldAccessorFactory $outer;

        public RecursiveProductFieldAccessor(DefaultScalaProductFieldAccessorFactory $outer, int pos, TypeInformation<T> typeInfo, FieldAccessor<R, F> innerAccessor, ExecutionConfig config) {
            this.pos = pos;
            this.innerAccessor = innerAccessor;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Preconditions.checkNotNull(typeInfo, (String)"typeInfo must not be null.");
            int arity = typeInfo.getArity();
            if (pos < 0 || pos >= arity) {
                throw new CompositeType.InvalidFieldReferenceException(new StringBuilder(57).append("Tried to select ").append(BoxesRunTime.boxToInteger((int)pos)).append(". field on \"").append(typeInfo).append("\", which is an invalid index.").toString());
            }
            Preconditions.checkNotNull(innerAccessor, (String)"innerAccessor must not be null.");
            this.fieldType = innerAccessor.getFieldType();
            this.serializer = (TupleSerializerBase)typeInfo.createSerializer(config.getSerializerConfig());
            this.length = this.serializer.getArity();
            this.fields = new Object[this.length];
        }

        private int pos() {
            return this.pos;
        }

        private FieldAccessor<R, F> innerAccessor() {
            return this.innerAccessor;
        }

        public F get(T record) {
            return (F)this.innerAccessor().get(((Product)record).productElement(this.pos()));
        }

        public T set(T record, F fieldValue) {
            Product prod = (Product)record;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                this.fields[i] = prod.productElement(i);
            });
            this.fields[this.pos()] = this.innerAccessor().set(this.fields[this.pos()], fieldValue);
            return (T)this.serializer.createInstance(this.fields);
        }

        public final /* synthetic */ DefaultScalaProductFieldAccessorFactory org$apache$flink$streaming$util$typeutils$DefaultScalaProductFieldAccessorFactory$RecursiveProductFieldAccessor$$$outer() {
            return this.$outer;
        }
    }

    public final class SimpleProductFieldAccessor<T, F>
    extends FieldAccessor<T, F> {
        private static final long serialVersionUID = 1L;
        private final int pos;
        private final TupleSerializerBase<T> serializer;
        private final int length;
        private final Object[] fields;
        private final /* synthetic */ DefaultScalaProductFieldAccessorFactory $outer;

        public SimpleProductFieldAccessor(DefaultScalaProductFieldAccessorFactory $outer, int pos, TypeInformation<T> typeInfo, ExecutionConfig config) {
            this.pos = pos;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Preconditions.checkNotNull(typeInfo, (String)"typeInfo must not be null.");
            int arity = typeInfo.getArity();
            if (pos < 0 || pos >= arity) {
                throw new CompositeType.InvalidFieldReferenceException(new StringBuilder(57).append("Tried to select ").append(pos).append(". field on \"").append(typeInfo).append("\", which is an invalid index.").toString());
            }
            this.fieldType = ((TupleTypeInfoBase)typeInfo).getTypeAt(pos);
            this.serializer = (TupleSerializerBase)typeInfo.createSerializer(config.getSerializerConfig());
            this.length = this.serializer.getArity();
            this.fields = new Object[this.length];
        }

        private int pos() {
            return this.pos;
        }

        public F get(T record) {
            Product prod = (Product)record;
            return (F)prod.productElement(this.pos());
        }

        public T set(T record, F fieldValue) {
            Product prod = (Product)record;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                this.fields[i] = prod.productElement(i);
            });
            this.fields[this.pos()] = fieldValue;
            return (T)this.serializer.createInstance(this.fields);
        }

        public final /* synthetic */ DefaultScalaProductFieldAccessorFactory org$apache$flink$streaming$util$typeutils$DefaultScalaProductFieldAccessorFactory$SimpleProductFieldAccessor$$$outer() {
            return this.$outer;
        }
    }
}

