/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flinkx.api;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.QueryableStateStream;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.functions.aggregation.AggregationFunction;
import org.apache.flink.streaming.api.functions.aggregation.ComparableAggregator;
import org.apache.flink.streaming.api.functions.aggregation.SumAggregator;
import org.apache.flink.streaming.api.functions.co.ProcessJoinFunction;
import org.apache.flink.streaming.api.functions.query.QueryableAppendingStateOperator;
import org.apache.flink.streaming.api.functions.query.QueryableValueStateOperator;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.windows.GlobalWindow;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.util.Collector;
import org.apache.flinkx.api.DataStream;
import org.apache.flinkx.api.ScalaStreamOps$;
import org.apache.flinkx.api.WindowedStream;
import org.apache.flinkx.api.function.StatefulFunction;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;

@Public
public class KeyedStream<T, K>
extends DataStream<T> {
    private final org.apache.flink.streaming.api.datastream.KeyedStream<T, K> javaStream;

    public KeyedStream(org.apache.flink.streaming.api.datastream.KeyedStream<T, K> javaStream) {
        this.javaStream = javaStream;
        super(javaStream);
    }

    @Internal
    private TypeInformation<K> getKeyType() {
        return this.javaStream.getKeyType();
    }

    @Override
    @PublicEvolving
    public <R> DataStream<R> process(ProcessFunction<T, R> processFunction, TypeInformation<R> evidence$1) {
        if (processFunction == null) {
            throw new NullPointerException("ProcessFunction must not be null.");
        }
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.process(processFunction, (TypeInformation)Predef$.MODULE$.implicitly(evidence$1)));
    }

    @PublicEvolving
    public <R> DataStream<R> process(KeyedProcessFunction<K, T, R> keyedProcessFunction, TypeInformation<R> evidence$1) {
        if (keyedProcessFunction == null) {
            throw new NullPointerException("KeyedProcessFunction must not be null.");
        }
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.process(keyedProcessFunction, (TypeInformation)Predef$.MODULE$.implicitly(evidence$1)));
    }

    @PublicEvolving
    public <OTHER> IntervalJoin<T, OTHER, K> intervalJoin(KeyedStream<OTHER, K> otherStream) {
        return new IntervalJoin(this, this, otherStream);
    }

    public WindowedStream<T, K, GlobalWindow> countWindow(long size, long slide) {
        return new WindowedStream(this.javaStream.countWindow(size, slide));
    }

    public WindowedStream<T, K, GlobalWindow> countWindow(long size) {
        return new WindowedStream(this.javaStream.countWindow(size));
    }

    @PublicEvolving
    public <W extends Window> WindowedStream<T, K, W> window(WindowAssigner<? super T, W> assigner) {
        return new WindowedStream(new org.apache.flink.streaming.api.datastream.WindowedStream(this.javaStream, assigner));
    }

    public DataStream<T> reduce(ReduceFunction<T> reducer) {
        if (reducer == null) {
            throw new NullPointerException("Reduce function must not be null.");
        }
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.reduce(reducer));
    }

    public DataStream<T> reduce(Function2<T, T, T> fun) {
        if (fun == null) {
            throw new NullPointerException("Reduce function must not be null.");
        }
        Function2<T, T, T> cleanFun = this.clean(fun);
        ReduceFunction reducer = new ReduceFunction<T>(cleanFun){
            private final Function2 cleanFun$1;
            {
                this.cleanFun$1 = cleanFun$8;
            }

            public Object reduce(Object v1, Object v2) {
                return this.cleanFun$1.apply(v1, v2);
            }
        };
        return this.reduce(reducer);
    }

    public DataStream<T> max(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MAX, position);
    }

    public DataStream<T> max(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MAX, field);
    }

    public DataStream<T> min(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MIN, position);
    }

    public DataStream<T> min(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MIN, field);
    }

    public DataStream<T> sum(int position) {
        return this.aggregate(AggregationFunction.AggregationType.SUM, position);
    }

    public DataStream<T> sum(String field) {
        return this.aggregate(AggregationFunction.AggregationType.SUM, field);
    }

    public DataStream<T> minBy(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MINBY, position);
    }

    public DataStream<T> minBy(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MINBY, field);
    }

    public DataStream<T> maxBy(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MAXBY, position);
    }

    public DataStream<T> maxBy(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MAXBY, field);
    }

    private DataStream<T> aggregate(AggregationFunction.AggregationType aggregationType, String field) {
        AggregationFunction.AggregationType aggregationType2 = aggregationType;
        AggregationFunction.AggregationType aggregationType3 = AggregationFunction.AggregationType.SUM;
        AggregationFunction.AggregationType aggregationType4 = aggregationType2;
        SumAggregator aggregationFunc = !(aggregationType3 != null ? !aggregationType3.equals(aggregationType4) : aggregationType4 != null) ? new SumAggregator(field, this.javaStream.getType(), this.javaStream.getExecutionConfig()) : new ComparableAggregator(field, this.javaStream.getType(), aggregationType, true, this.javaStream.getExecutionConfig());
        return this.aggregate((AggregationFunction<T>)aggregationFunc);
    }

    private DataStream<T> aggregate(AggregationFunction.AggregationType aggregationType, int position) {
        AggregationFunction.AggregationType aggregationType2 = aggregationType;
        AggregationFunction.AggregationType aggregationType3 = AggregationFunction.AggregationType.SUM;
        AggregationFunction.AggregationType aggregationType4 = aggregationType2;
        SumAggregator aggregationFunc = !(aggregationType3 != null ? !aggregationType3.equals(aggregationType4) : aggregationType4 != null) ? new SumAggregator(position, this.javaStream.getType(), this.javaStream.getExecutionConfig()) : new ComparableAggregator(position, this.javaStream.getType(), aggregationType, true, this.javaStream.getExecutionConfig());
        return this.aggregate((AggregationFunction<T>)aggregationFunc);
    }

    private DataStream<T> aggregate(AggregationFunction<T> aggregationFunc) {
        return this.reduce((ReduceFunction<T>)aggregationFunc).name("Keyed Aggregation");
    }

    public <S> DataStream<T> filterWithState(Function2<T, Option<S>, Tuple2<Object, Option<S>>> fun, TypeInformation<S> evidence$1) {
        if (fun == null) {
            throw new NullPointerException("Filter function must not be null.");
        }
        Function2<T, Option<S>, Tuple2<Object, Option<S>>> cleanFun = this.clean(fun);
        TypeInformation stateTypeInfo = (TypeInformation)Predef$.MODULE$.implicitly(evidence$1);
        TypeSerializer serializer = stateTypeInfo.createSerializer(this.javaStream.getExecutionEnvironment().getConfig().getSerializerConfig());
        StatefulFunction filterFun = new StatefulFunction<T, Object, S>(serializer, cleanFun){
            private final Function2 cleanFun$3;
            private ValueState org$apache$flinkx$api$function$StatefulFunction$$state;
            private final TypeSerializer stateSerializer;
            {
                this.cleanFun$3 = cleanFun$2;
                StatefulFunction.$init$(this);
                this.stateSerializer = serializer$1;
            }

            public ValueState org$apache$flinkx$api$function$StatefulFunction$$state() {
                return this.org$apache$flinkx$api$function$StatefulFunction$$state;
            }

            public void org$apache$flinkx$api$function$StatefulFunction$$state_$eq(ValueState x$1) {
                this.org$apache$flinkx$api$function$StatefulFunction$$state = x$1;
            }

            public TypeSerializer stateSerializer() {
                return this.stateSerializer;
            }

            public boolean filter(Object in) {
                return BoxesRunTime.unboxToBoolean((Object)this.applyWithState(in, this.cleanFun$3));
            }
        };
        return this.filter(filterFun);
    }

    public <R, S> DataStream<R> mapWithState(Function2<T, Option<S>, Tuple2<R, Option<S>>> fun, TypeInformation<R> evidence$1, TypeInformation<S> evidence$2) {
        if (fun == null) {
            throw new NullPointerException("Map function must not be null.");
        }
        Function2<T, Option<S>, Tuple2<R, Option<S>>> cleanFun = this.clean(fun);
        TypeInformation stateTypeInfo = (TypeInformation)Predef$.MODULE$.implicitly(evidence$2);
        TypeSerializer serializer = stateTypeInfo.createSerializer(this.javaStream.getExecutionEnvironment().getConfig().getSerializerConfig());
        StatefulFunction mapper = new StatefulFunction<T, R, S>(serializer, cleanFun){
            private final Function2 cleanFun$5;
            private ValueState org$apache$flinkx$api$function$StatefulFunction$$state;
            private final TypeSerializer stateSerializer;
            {
                this.cleanFun$5 = cleanFun$4;
                StatefulFunction.$init$(this);
                this.stateSerializer = serializer$2;
            }

            public ValueState org$apache$flinkx$api$function$StatefulFunction$$state() {
                return this.org$apache$flinkx$api$function$StatefulFunction$$state;
            }

            public void org$apache$flinkx$api$function$StatefulFunction$$state_$eq(ValueState x$1) {
                this.org$apache$flinkx$api$function$StatefulFunction$$state = x$1;
            }

            public TypeSerializer stateSerializer() {
                return this.stateSerializer;
            }

            public Object map(Object in) {
                return this.applyWithState(in, this.cleanFun$5);
            }
        };
        return this.map(mapper, evidence$1);
    }

    public <R, S> DataStream<R> flatMapWithState(Function2<T, Option<S>, Tuple2<IterableOnce<R>, Option<S>>> fun, TypeInformation<R> evidence$1, TypeInformation<S> evidence$2) {
        if (fun == null) {
            throw new NullPointerException("Flatmap function must not be null.");
        }
        Function2<T, Option<S>, Tuple2<IterableOnce<R>, Option<S>>> cleanFun = this.clean(fun);
        TypeInformation stateTypeInfo = (TypeInformation)Predef$.MODULE$.implicitly(evidence$2);
        TypeSerializer serializer = stateTypeInfo.createSerializer(this.javaStream.getExecutionEnvironment().getConfig().getSerializerConfig());
        StatefulFunction flatMapper = new StatefulFunction<T, IterableOnce<R>, S>(serializer, cleanFun){
            private final Function2 cleanFun$7;
            private ValueState org$apache$flinkx$api$function$StatefulFunction$$state;
            private final TypeSerializer stateSerializer;
            {
                this.cleanFun$7 = cleanFun$6;
                StatefulFunction.$init$(this);
                this.stateSerializer = serializer$3;
            }

            public ValueState org$apache$flinkx$api$function$StatefulFunction$$state() {
                return this.org$apache$flinkx$api$function$StatefulFunction$$state;
            }

            public void org$apache$flinkx$api$function$StatefulFunction$$state_$eq(ValueState x$1) {
                this.org$apache$flinkx$api$function$StatefulFunction$$state = x$1;
            }

            public TypeSerializer stateSerializer() {
                return this.stateSerializer;
            }

            public void flatMap(Object in, Collector out) {
                ((IterableOnce)this.applyWithState(in, this.cleanFun$7)).iterator().foreach((Function1)((JProcedure1 & Serializable)arg_0 -> KeyedStream.org$apache$flinkx$api$KeyedStream$$anon$4$$_$flatMap$$anonfun$1(out, arg_0)));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$flinkx$api$KeyedStream$$anon$4$$_$flatMap$$anonfun$1(org.apache.flink.util.Collector java.lang.Object )}, serializedLambda);
            }
        };
        return this.flatMap(flatMapper, evidence$1);
    }

    @Deprecated
    public QueryableStateStream<K, T> asQueryableState(String queryableStateName) {
        ValueStateDescriptor stateDescriptor = new ValueStateDescriptor(queryableStateName, this.dataType().createSerializer(this.serializerConfig()));
        return this.asQueryableState(queryableStateName, stateDescriptor);
    }

    @Deprecated
    public QueryableStateStream<K, T> asQueryableState(String queryableStateName, ValueStateDescriptor<T> stateDescriptor) {
        this.transform(new StringBuilder(17).append("Queryable state: ").append(queryableStateName).toString(), new QueryableValueStateOperator(queryableStateName, stateDescriptor), this.dataType());
        stateDescriptor.initializeSerializerUnlessSet(this.executionConfig());
        return new QueryableStateStream(queryableStateName, stateDescriptor, this.getKeyType().createSerializer(this.serializerConfig()));
    }

    @Deprecated
    public QueryableStateStream<K, T> asQueryableState(String queryableStateName, ReducingStateDescriptor<T> stateDescriptor) {
        this.transform(new StringBuilder(17).append("Queryable state: ").append(queryableStateName).toString(), new QueryableAppendingStateOperator(queryableStateName, stateDescriptor), this.dataType());
        stateDescriptor.initializeSerializerUnlessSet(this.executionConfig());
        return new QueryableStateStream(queryableStateName, stateDescriptor, this.getKeyType().createSerializer(this.serializerConfig()));
    }

    public static final /* synthetic */ void org$apache$flinkx$api$KeyedStream$$anon$4$$_$flatMap$$anonfun$1(Collector out$1, Object x$0) {
        out$1.collect(x$0);
    }

    @PublicEvolving
    public class IntervalJoin<IN1, IN2, KEY> {
        private final KeyedStream streamOne;
        private final KeyedStream streamTwo;
        private final /* synthetic */ KeyedStream $outer;

        public IntervalJoin(KeyedStream $outer, KeyedStream<IN1, KEY> streamOne, KeyedStream<IN2, KEY> streamTwo) {
            this.streamOne = streamOne;
            this.streamTwo = streamTwo;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public KeyedStream<IN1, KEY> streamOne() {
            return this.streamOne;
        }

        public KeyedStream<IN2, KEY> streamTwo() {
            return this.streamTwo;
        }

        @PublicEvolving
        public IntervalJoined<IN1, IN2, KEY> between(Duration lowerBound, Duration upperBound) {
            long lowerMillis = lowerBound.toMillis();
            long upperMillis = upperBound.toMillis();
            return new IntervalJoined<IN1, IN2, KEY>(this.$outer, this.streamOne(), this.streamTwo(), lowerMillis, upperMillis);
        }

        public final /* synthetic */ KeyedStream org$apache$flinkx$api$KeyedStream$IntervalJoin$$$outer() {
            return this.$outer;
        }
    }

    @PublicEvolving
    public class IntervalJoined<IN1, IN2, KEY> {
        private final KeyedStream firstStream;
        private final KeyedStream secondStream;
        private final long lowerBound;
        private final long upperBound;
        private boolean lowerBoundInclusive;
        private boolean upperBoundInclusive;
        private final /* synthetic */ KeyedStream $outer;

        public IntervalJoined(KeyedStream $outer, KeyedStream<IN1, KEY> firstStream, KeyedStream<IN2, KEY> secondStream, long lowerBound, long upperBound) {
            this.firstStream = firstStream;
            this.secondStream = secondStream;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.lowerBoundInclusive = true;
            this.upperBoundInclusive = true;
        }

        private KeyedStream<IN1, KEY> firstStream() {
            return this.firstStream;
        }

        private KeyedStream<IN2, KEY> secondStream() {
            return this.secondStream;
        }

        private long lowerBound() {
            return this.lowerBound;
        }

        private long upperBound() {
            return this.upperBound;
        }

        @PublicEvolving
        public IntervalJoined<IN1, IN2, KEY> lowerBoundExclusive() {
            this.lowerBoundInclusive = false;
            return this;
        }

        @PublicEvolving
        public IntervalJoined<IN1, IN2, KEY> upperBoundExclusive() {
            this.upperBoundInclusive = false;
            return this;
        }

        @PublicEvolving
        public <OUT> DataStream<OUT> process(ProcessJoinFunction<IN1, IN2, OUT> processJoinFunction, TypeInformation<OUT> evidence$1) {
            TypeInformation outType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$1);
            KeyedStream.IntervalJoined javaJoined = new KeyedStream.IntervalJoined((org.apache.flink.streaming.api.datastream.KeyedStream)this.firstStream().javaStream(), (org.apache.flink.streaming.api.datastream.KeyedStream)this.secondStream().javaStream(), this.lowerBound(), this.upperBound(), this.lowerBoundInclusive, this.upperBoundInclusive);
            return ScalaStreamOps$.MODULE$.asScalaStream(javaJoined.process(processJoinFunction, outType));
        }

        public final /* synthetic */ KeyedStream org$apache$flinkx$api$KeyedStream$IntervalJoined$$$outer() {
            return this.$outer;
        }
    }
}

