/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flinkx.api;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.Configuration;
import org.apache.flinkx.api.StreamExecutionEnvironment;
import org.apache.flinkx.api.typeinfo.FailFastTypeInfoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.sys.package$;
import scala.util.Either;
import scala.util.Try$;

public final class StreamExecutionEnvironment$
implements Serializable {
    private volatile transient Object log$lzy1;
    private static boolean isFailFastOnScalaTypeResolutionWithClassConfigured;
    private volatile Object isFailFastOnScalaTypeResolutionWithClassDisabled$lzy1;
    public static final StreamExecutionEnvironment$ MODULE$;

    private StreamExecutionEnvironment$() {
    }

    static {
        MODULE$ = new StreamExecutionEnvironment$();
        isFailFastOnScalaTypeResolutionWithClassConfigured = false;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StreamExecutionEnvironment$.class);
    }

    public Logger log() {
        Object object = this.log$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, StreamExecutionEnvironment.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger(StreamExecutionEnvironment.class);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, StreamExecutionEnvironment.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, StreamExecutionEnvironment.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, StreamExecutionEnvironment.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @PublicEvolving
    public void setDefaultLocalParallelism(int parallelism) {
        org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.setDefaultLocalParallelism((int)parallelism);
    }

    @PublicEvolving
    public int getDefaultLocalParallelism() {
        return org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.getDefaultLocalParallelism();
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        this.configureExtra();
        return new StreamExecutionEnvironment(org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.getExecutionEnvironment());
    }

    public StreamExecutionEnvironment getExecutionEnvironment(Configuration configuration) {
        this.configureExtra();
        return new StreamExecutionEnvironment(org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.getExecutionEnvironment((Configuration)configuration));
    }

    public StreamExecutionEnvironment createLocalEnvironment(int parallelism) {
        this.configureExtra();
        return new StreamExecutionEnvironment((org.apache.flink.streaming.api.environment.StreamExecutionEnvironment)org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.createLocalEnvironment((int)parallelism));
    }

    public int createLocalEnvironment$default$1() {
        return org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.getDefaultLocalParallelism();
    }

    public StreamExecutionEnvironment createLocalEnvironment(int parallelism, Configuration configuration) {
        this.configureExtra();
        return new StreamExecutionEnvironment((org.apache.flink.streaming.api.environment.StreamExecutionEnvironment)org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.createLocalEnvironment((int)parallelism, (Configuration)configuration));
    }

    @PublicEvolving
    public StreamExecutionEnvironment createLocalEnvironmentWithWebUI(Configuration config) {
        this.configureExtra();
        Configuration conf = config == null ? new Configuration() : config;
        return new StreamExecutionEnvironment(org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.createLocalEnvironmentWithWebUI((Configuration)conf));
    }

    public Configuration createLocalEnvironmentWithWebUI$default$1() {
        return null;
    }

    public StreamExecutionEnvironment createRemoteEnvironment(String host, int port, Seq<String> jarFiles) {
        this.configureExtra();
        return new StreamExecutionEnvironment(org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.createRemoteEnvironment((String)host, (int)port, (String[])((String[])Arrays$.MODULE$.seqToArray(jarFiles, String.class))));
    }

    public StreamExecutionEnvironment createRemoteEnvironment(String host, int port, int parallelism, Seq<String> jarFiles) {
        this.configureExtra();
        org.apache.flink.streaming.api.environment.StreamExecutionEnvironment javaEnv = org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.createRemoteEnvironment((String)host, (int)port, (String[])((String[])Arrays$.MODULE$.seqToArray(jarFiles, String.class)));
        javaEnv.setParallelism(parallelism);
        return new StreamExecutionEnvironment(javaEnv);
    }

    public StreamExecutionEnvironment createRemoteEnvironment(String host, int port, Configuration config, Seq<String> jarFiles) {
        this.configureExtra();
        org.apache.flink.streaming.api.environment.StreamExecutionEnvironment javaEnv = org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.createRemoteEnvironment((String)host, (int)port, (Configuration)config, (String[])((String[])Arrays$.MODULE$.seqToArray(jarFiles, String.class)));
        return new StreamExecutionEnvironment(javaEnv);
    }

    private void configureExtra() {
        if (!isFailFastOnScalaTypeResolutionWithClassConfigured && !this.isFailFastOnScalaTypeResolutionWithClassDisabled()) {
            isFailFastOnScalaTypeResolutionWithClassConfigured = true;
            try {
                Class<?> typeExtractorClass = Class.forName("org.apache.flink.api.java.typeutils.TypeExtractor");
                Method registerFactoryMethod = typeExtractorClass.getMethod("registerFactory", Type.class, Class.class);
                registerFactoryMethod.invoke(null, Product.class, FailFastTypeInfoFactory.class);
                registerFactoryMethod.invoke(null, Option.class, FailFastTypeInfoFactory.class);
                registerFactoryMethod.invoke(null, Either.class, FailFastTypeInfoFactory.class);
                registerFactoryMethod.invoke(null, Iterable.class, FailFastTypeInfoFactory.class);
            }
            catch (Throwable t) {
                this.log().info(new StringBuilder(103).append("Unable to activate 'fail-fast on Scala type resolution with Class' feature: available from Flink 1.19: ").append(t).toString());
            }
            return;
        }
    }

    private boolean isFailFastOnScalaTypeResolutionWithClassDisabled() {
        Object object = this.isFailFastOnScalaTypeResolutionWithClassDisabled$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.isFailFastOnScalaTypeResolutionWithClassDisabled$lzyINIT1());
    }

    private Object isFailFastOnScalaTypeResolutionWithClassDisabled$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.isFailFastOnScalaTypeResolutionWithClassDisabled$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, StreamExecutionEnvironment.OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        bl = BoxesRunTime.boxToBoolean((boolean)package$.MODULE$.env().get((Object)"DISABLE_FAIL_FAST_ON_SCALA_TYPE_RESOLUTION_WITH_CLASS").exists((Function1 & Serializable)v -> BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply(() -> StreamExecutionEnvironment$.isFailFastOnScalaTypeResolutionWithClassDisabled$lzyINIT1$$anonfun$1$$anonfun$1(v)).getOrElse(StreamExecutionEnvironment$::isFailFastOnScalaTypeResolutionWithClassDisabled$lzyINIT1$$anonfun$1$$anonfun$2))));
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, StreamExecutionEnvironment.OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.isFailFastOnScalaTypeResolutionWithClassDisabled$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, StreamExecutionEnvironment.OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, StreamExecutionEnvironment.OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private static final boolean isFailFastOnScalaTypeResolutionWithClassDisabled$lzyINIT1$$anonfun$1$$anonfun$1(String v$1) {
        return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(v$1));
    }

    private static final boolean isFailFastOnScalaTypeResolutionWithClassDisabled$lzyINIT1$$anonfun$1$$anonfun$2() {
        return false;
    }
}

