/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flinkx.api.mapper;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.flinkx.api.serializer.MappedSerializer;

public class UuidMapper
implements MappedSerializer.TypeMapper<UUID, byte[]> {
    @Override
    public byte[] map(UUID a) {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(a.getMostSignificantBits());
        buffer.putLong(a.getLeastSignificantBits());
        return buffer.array();
    }

    @Override
    public UUID contramap(byte[] b) {
        ByteBuffer buffer = ByteBuffer.wrap(b);
        long mostSignificantBits = buffer.getLong();
        long leastSignificantBits = buffer.getLong();
        return new UUID(mostSignificantBits, leastSignificantBits);
    }
}

