/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flinkx.api.serializer;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flinkx.api.serializer.CollectionSerializerSnapshot;
import org.apache.flinkx.api.serializer.MutableSerializer;
import scala.Array$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.ScalaRunTime$;

public class ArraySerializer<T>
extends MutableSerializer<Object> {
    private final TypeSerializer child;
    private final Class<T> clazz;
    private final ClassTag classTag;

    public ArraySerializer(TypeSerializer<T> child, Class<T> clazz) {
        this.child = child;
        this.clazz = clazz;
        this.classTag = ClassTag$.MODULE$.apply(clazz);
    }

    public TypeSerializer<T> child() {
        return this.child;
    }

    public ClassTag<T> classTag() {
        return this.classTag;
    }

    public Object createInstance() {
        return Array$.MODULE$.empty(this.classTag());
    }

    public Object copy(Object from) {
        if (from == null) {
            return from;
        }
        int length = ScalaRunTime$.MODULE$.array_length(from);
        Object copy = Array$.MODULE$.copyOf(from, length);
        if (!this.child().isImmutableType()) {
            for (int i = 0; i < length; ++i) {
                Object element = ScalaRunTime$.MODULE$.array_apply(copy, i);
                if (element == null) continue;
                ScalaRunTime$.MODULE$.array_update(copy, i, this.child().copy(element));
            }
        }
        return copy;
    }

    public ArraySerializer<T> duplicate() {
        TypeSerializer duplicatedChild = this.child().duplicate();
        if (duplicatedChild == this.child()) {
            return this;
        }
        return new ArraySerializer<T>(duplicatedChild, this.clazz);
    }

    public int getLength() {
        return -1;
    }

    public Object deserialize(DataInputView source) {
        int length = source.readInt();
        Object array = Arrays$.MODULE$.newGenericArray(length, this.classTag());
        for (int i = 0; i < length; ++i) {
            ScalaRunTime$.MODULE$.array_update(array, i, this.child().deserialize(source));
        }
        return array;
    }

    public void serialize(Object record, DataOutputView target) {
        int length = ScalaRunTime$.MODULE$.array_length(record);
        target.writeInt(length);
        for (int i = 0; i < length; ++i) {
            Object element = ScalaRunTime$.MODULE$.array_apply(record, i);
            this.child().serialize(element, target);
        }
    }

    public TypeSerializerSnapshot<Object> snapshotConfiguration() {
        return new CollectionSerializerSnapshot(this.child(), ArraySerializer.class, this.clazz);
    }
}

