/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flinkx.api.serializer;

import java.io.Serializable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flinkx.api.serializer.CoproductSerializer$;
import org.apache.flinkx.api.serializer.MutableSerializer;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;

public class CoproductSerializer<T>
extends MutableSerializer<T> {
    private final Class<?>[] subtypeClasses;
    private final TypeSerializer<?>[] subtypeSerializers;
    private final boolean isImmutableType;
    private final boolean isImmutableSerializer;

    public CoproductSerializer(Class<?>[] subtypeClasses, TypeSerializer<?>[] subtypeSerializers) {
        this.subtypeClasses = subtypeClasses;
        this.subtypeSerializers = subtypeSerializers;
        Object object = Predef$.MODULE$.refArrayOps((Object[])subtypeSerializers);
        this.isImmutableType = ArrayOps$.MODULE$.forall$extension(object, (Function1 & Serializable)_$1 -> _$1.isImmutableType());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])subtypeSerializers);
        this.isImmutableSerializer = ArrayOps$.MODULE$.forall$extension(object2, (Function1 & Serializable)s -> s.duplicate() == s);
    }

    public boolean isImmutableType() {
        return this.isImmutableType;
    }

    public boolean isImmutableSerializer() {
        return this.isImmutableSerializer;
    }

    public T copy(T from) {
        if (from == null || this.isImmutableType()) {
            return from;
        }
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.subtypeClasses);
        int i = ArrayOps$.MODULE$.indexWhere$extension(object, (Function1 & Serializable)_$2 -> _$2.isInstance(from), ArrayOps$.MODULE$.indexWhere$default$2$extension(object));
        return (T)this.subtypeSerializers[i].copy(from);
    }

    public CoproductSerializer<T> duplicate() {
        if (this.isImmutableSerializer()) {
            return this;
        }
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.subtypeSerializers);
        return new CoproductSerializer<T>(this.subtypeClasses, (TypeSerializer[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$3 -> _$3.duplicate(), ClassTag$.MODULE$.apply(TypeSerializer.class)));
    }

    public T createInstance() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.subtypeSerializers);
        return (T)((TypeSerializer)ArrayOps$.MODULE$.head$extension(object)).createInstance();
    }

    public int getLength() {
        return -1;
    }

    public void serialize(T record, DataOutputView target) {
        int subtypeIndex = 0;
        boolean found = false;
        while (!found && subtypeIndex < this.subtypeClasses.length) {
            if (this.subtypeClasses[subtypeIndex].isInstance(record)) {
                found = true;
                continue;
            }
            ++subtypeIndex;
        }
        if (found) {
            target.writeByte((int)((byte)subtypeIndex));
            this.subtypeSerializers[subtypeIndex].serialize(record, target);
            return;
        }
        throw new IllegalStateException("subtype not found in sealed trait schema");
    }

    public T deserialize(DataInputView source) {
        byte index = source.readByte();
        TypeSerializer<?> subtype = this.subtypeSerializers[index];
        return (T)subtype.deserialize(source);
    }

    public TypeSerializerSnapshot<T> snapshotConfiguration() {
        return new CoproductSerializerSnapshot(this.subtypeClasses, this.subtypeSerializers);
    }

    public static class CoproductSerializerSnapshot<T>
    implements TypeSerializerSnapshot<T> {
        private Class[] subtypeClasses;
        private TypeSerializer[] subtypeSerializers;

        public CoproductSerializerSnapshot(Class<?>[] subtypeClasses, TypeSerializer<?>[] subtypeSerializers) {
            this.subtypeClasses = subtypeClasses;
            this.subtypeSerializers = subtypeSerializers;
        }

        public Class<?>[] subtypeClasses() {
            return this.subtypeClasses;
        }

        public void subtypeClasses_$eq(Class<?>[] x$1) {
            this.subtypeClasses = x$1;
        }

        public TypeSerializer<?>[] subtypeSerializers() {
            return this.subtypeSerializers;
        }

        public void subtypeSerializers_$eq(TypeSerializer<?>[] x$1) {
            this.subtypeSerializers = x$1;
        }

        public CoproductSerializerSnapshot() {
            this((Class[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Class.class)), (TypeSerializer[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(TypeSerializer.class)));
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) {
            int len = in.readInt();
            this.subtypeClasses_$eq((Class[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).map(arg_0 -> CoproductSerializer$.org$apache$flinkx$api$serializer$CoproductSerializer$CoproductSerializerSnapshot$$_$readSnapshot$$anonfun$adapted$1(in, userCodeClassLoader, arg_0)).toArray(ClassTag$.MODULE$.apply(Class.class)));
            this.subtypeSerializers_$eq((TypeSerializer[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).map(arg_0 -> CoproductSerializer$.org$apache$flinkx$api$serializer$CoproductSerializer$CoproductSerializerSnapshot$$_$readSnapshot$$anonfun$adapted$2(in, userCodeClassLoader, arg_0)).toArray(ClassTag$.MODULE$.apply(TypeSerializer.class)));
        }

        public int getCurrentVersion() {
            return 2;
        }

        public void writeSnapshot(DataOutputView out) {
            out.writeInt(this.subtypeClasses().length);
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.subtypeClasses());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)((JProcedure1 & Serializable)arg_0 -> CoproductSerializer$.org$apache$flinkx$api$serializer$CoproductSerializer$CoproductSerializerSnapshot$$_$writeSnapshot$$anonfun$1(out, arg_0)));
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])this.subtypeSerializers());
            ArrayOps$.MODULE$.foreach$extension(object2, (Function1)((JProcedure1 & Serializable)arg_0 -> CoproductSerializer$.org$apache$flinkx$api$serializer$CoproductSerializer$CoproductSerializerSnapshot$$_$writeSnapshot$$anonfun$2(out, arg_0)));
        }

        public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializerSnapshot<T> oldSerializerSnapshot) {
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }

        public TypeSerializer<T> restoreSerializer() {
            return new CoproductSerializer(this.subtypeClasses(), this.subtypeSerializers());
        }
    }
}

