/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flinkx.api.serializer;

import java.io.Serializable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flinkx.api.serializer.MapSerializer$MapSerializerSnapshot$;
import org.apache.flinkx.api.serializer.MutableSerializer;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class MapSerializer<K, V>
extends MutableSerializer<Map<K, V>> {
    private final TypeSerializer<K> ks;
    private final TypeSerializer<V> vs;
    private final boolean isImmutableType;

    public MapSerializer(TypeSerializer<K> ks, TypeSerializer<V> vs) {
        this.ks = ks;
        this.vs = vs;
        this.isImmutableType = ks.isImmutableType() && vs.isImmutableType();
    }

    public boolean isImmutableType() {
        return this.isImmutableType;
    }

    public Map<K, V> copy(Map<K, V> from) {
        if (from == null || this.isImmutableType()) {
            return from;
        }
        return (Map)from.map((Function1 & Serializable)element -> Tuple2$.MODULE$.apply(this.ks.copy(element._1()), this.vs.copy(element._2())));
    }

    public MapSerializer<K, V> duplicate() {
        TypeSerializer duplicatedKS = this.ks.duplicate();
        TypeSerializer duplicatedVS = this.vs.duplicate();
        if (duplicatedKS == this.ks && duplicatedVS == this.vs) {
            return this;
        }
        return new MapSerializer<K, V>(duplicatedKS, duplicatedVS);
    }

    public Map<K, V> createInstance() {
        return Predef$.MODULE$.Map().empty();
    }

    public int getLength() {
        return -1;
    }

    public Map<K, V> deserialize(DataInputView source) {
        int count = source.readInt();
        IndexedSeq result = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).map((Function1 & Serializable)x$1 -> this.$anonfun$1(source, BoxesRunTime.unboxToInt((Object)x$1)));
        return result.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void serialize(Map<K, V> record, DataOutputView target) {
        target.writeInt(record.size());
        record.foreach((Function1)(JProcedure1 & Serializable)element -> {
            this.ks.serialize(element._1(), target);
            this.vs.serialize(element._2(), target);
        });
    }

    public TypeSerializerSnapshot<Map<K, V>> snapshotConfiguration() {
        return new MapSerializerSnapshot<K, V>(this.ks, this.vs);
    }

    private final /* synthetic */ Tuple2 $anonfun$1(DataInputView source$1, int x$1) {
        int n = x$1;
        Object key = this.ks.deserialize(source$1);
        Object value = this.vs.deserialize(source$1);
        Object object = Predef$.MODULE$.ArrowAssoc(key);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, value);
    }

    public static class MapSerializerSnapshot<K, V>
    implements TypeSerializerSnapshot<Map<K, V>>,
    Product,
    Serializable {
        private TypeSerializer keySerializer;
        private TypeSerializer valueSerializer;

        public static <K, V> MapSerializerSnapshot<K, V> apply(TypeSerializer<K> typeSerializer, TypeSerializer<V> typeSerializer2) {
            return MapSerializer$MapSerializerSnapshot$.MODULE$.apply(typeSerializer, typeSerializer2);
        }

        public static MapSerializerSnapshot<?, ?> fromProduct(Product product) {
            return MapSerializer$MapSerializerSnapshot$.MODULE$.fromProduct(product);
        }

        public static <K, V> MapSerializerSnapshot<K, V> unapply(MapSerializerSnapshot<K, V> mapSerializerSnapshot) {
            return MapSerializer$MapSerializerSnapshot$.MODULE$.unapply(mapSerializerSnapshot);
        }

        public MapSerializerSnapshot(TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer) {
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MapSerializerSnapshot)) return false;
            MapSerializerSnapshot mapSerializerSnapshot = (MapSerializerSnapshot)object;
            TypeSerializer<K> typeSerializer = this.keySerializer();
            TypeSerializer<K> typeSerializer2 = mapSerializerSnapshot.keySerializer();
            if (typeSerializer == null) {
                if (typeSerializer2 != null) {
                    return false;
                }
            } else if (!typeSerializer.equals(typeSerializer2)) return false;
            TypeSerializer<V> typeSerializer3 = this.valueSerializer();
            TypeSerializer<V> typeSerializer4 = mapSerializerSnapshot.valueSerializer();
            if (typeSerializer3 == null) {
                if (typeSerializer4 != null) {
                    return false;
                }
            } else if (!typeSerializer3.equals(typeSerializer4)) return false;
            if (!mapSerializerSnapshot.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MapSerializerSnapshot;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "MapSerializerSnapshot";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "keySerializer";
            }
            if (1 == n2) {
                return "valueSerializer";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public TypeSerializer<K> keySerializer() {
            return this.keySerializer;
        }

        public void keySerializer_$eq(TypeSerializer<K> x$1) {
            this.keySerializer = x$1;
        }

        public TypeSerializer<V> valueSerializer() {
            return this.valueSerializer;
        }

        public void valueSerializer_$eq(TypeSerializer<V> x$1) {
            this.valueSerializer = x$1;
        }

        public MapSerializerSnapshot() {
            this(null, null);
        }

        public int getCurrentVersion() {
            return 2;
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) {
            this.keySerializer_$eq(TypeSerializerSnapshot.readVersionedSnapshot((DataInputView)in, (ClassLoader)userCodeClassLoader).restoreSerializer());
            this.valueSerializer_$eq(TypeSerializerSnapshot.readVersionedSnapshot((DataInputView)in, (ClassLoader)userCodeClassLoader).restoreSerializer());
        }

        public void writeSnapshot(DataOutputView out) {
            TypeSerializerSnapshot.writeVersionedSnapshot((DataOutputView)out, (TypeSerializerSnapshot)this.keySerializer().snapshotConfiguration());
            TypeSerializerSnapshot.writeVersionedSnapshot((DataOutputView)out, (TypeSerializerSnapshot)this.valueSerializer().snapshotConfiguration());
        }

        public TypeSerializerSchemaCompatibility<Map<K, V>> resolveSchemaCompatibility(TypeSerializerSnapshot<Map<K, V>> oldSerializerSnapshot) {
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }

        public TypeSerializer<Map<K, V>> restoreSerializer() {
            return new MapSerializer<K, V>(this.keySerializer(), this.valueSerializer());
        }

        public <K, V> MapSerializerSnapshot<K, V> copy(TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer) {
            return new MapSerializerSnapshot<K, V>(keySerializer, valueSerializer);
        }

        public <K, V> TypeSerializer<K> copy$default$1() {
            return this.keySerializer();
        }

        public <K, V> TypeSerializer<V> copy$default$2() {
            return this.valueSerializer();
        }

        public TypeSerializer<K> _1() {
            return this.keySerializer();
        }

        public TypeSerializer<V> _2() {
            return this.valueSerializer();
        }
    }
}

