/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flinkx.api.serializer;

import java.io.Serializable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flinkx.api.serializer.MappedSerializer$;
import org.apache.flinkx.api.serializer.MutableSerializer;
import scala.Product;
import scala.runtime.BoxesRunTime;

public class MappedSerializer<A, B>
extends MutableSerializer<A>
implements Product {
    private final TypeMapper mapper;
    private final TypeSerializer ser;
    private final boolean isImmutableType;

    public static <A, B> MappedSerializer<A, B> apply(TypeMapper<A, B> typeMapper, TypeSerializer<B> typeSerializer) {
        return MappedSerializer$.MODULE$.apply(typeMapper, typeSerializer);
    }

    public static MappedSerializer<?, ?> fromProduct(Product product) {
        return MappedSerializer$.MODULE$.fromProduct(product);
    }

    public static <A, B> MappedSerializer<A, B> unapply(MappedSerializer<A, B> mappedSerializer) {
        return MappedSerializer$.MODULE$.unapply(mappedSerializer);
    }

    public MappedSerializer(TypeMapper<A, B> mapper, TypeSerializer<B> ser) {
        this.mapper = mapper;
        this.ser = ser;
        this.isImmutableType = ser.isImmutableType();
    }

    public boolean canEqual(Object that) {
        return that instanceof MappedSerializer;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "MappedSerializer";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "mapper";
        }
        if (1 == n2) {
            return "ser";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public TypeMapper<A, B> mapper() {
        return this.mapper;
    }

    public TypeSerializer<B> ser() {
        return this.ser;
    }

    public boolean isImmutableType() {
        return this.isImmutableType;
    }

    public A copy(A from) {
        if (from == null || this.isImmutableType()) {
            return from;
        }
        return this.mapper().contramap(this.ser().copy(this.mapper().map(from)));
    }

    public MappedSerializer<A, B> duplicate() {
        TypeSerializer duplicatedSer = this.ser().duplicate();
        if (duplicatedSer == this.ser()) {
            return this;
        }
        return MappedSerializer$.MODULE$.apply(this.mapper(), duplicatedSer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof MappedSerializer)) return false;
        MappedSerializer that = (MappedSerializer)((Object)object);
        TypeMapper<A, B> typeMapper = this.mapper();
        TypeMapper<A, B> typeMapper2 = that.mapper();
        if (typeMapper == null) {
            if (typeMapper2 != null) {
                return false;
            }
        } else if (!typeMapper.equals(typeMapper2)) return false;
        TypeSerializer<B> typeSerializer = this.ser();
        TypeSerializer<B> typeSerializer2 = that.ser();
        if (typeSerializer == null) {
            if (typeSerializer2 == null) return true;
            return false;
        } else {
            if (!typeSerializer.equals(typeSerializer2)) return false;
            return true;
        }
    }

    public String toString() {
        return new StringBuilder(20).append("MappedSerializer(").append(this.mapper()).append(", ").append(this.ser()).append(")").toString();
    }

    public int hashCode() {
        return 31 * this.mapper().hashCode() + this.ser().hashCode();
    }

    public int getLength() {
        return this.ser().getLength();
    }

    public void serialize(A record, DataOutputView target) {
        this.ser().serialize(this.mapper().map(record), target);
    }

    public A deserialize(A reuse, DataInputView source) {
        return this.mapper().contramap(this.ser().deserialize(this.mapper().map(reuse), source));
    }

    public A deserialize(DataInputView source) {
        return this.mapper().contramap(this.ser().deserialize(source));
    }

    public TypeSerializerSnapshot<A> snapshotConfiguration() {
        return new MappedSerializerSnapshot<A, B>(this.mapper(), this.ser());
    }

    public A createInstance() {
        return this.mapper().contramap(this.ser().createInstance());
    }

    public <A, B> MappedSerializer<A, B> copy(TypeMapper<A, B> mapper, TypeSerializer<B> ser) {
        return new MappedSerializer<A, B>(mapper, ser);
    }

    public <A, B> TypeMapper<A, B> copy$default$1() {
        return this.mapper();
    }

    public <A, B> TypeSerializer<B> copy$default$2() {
        return this.ser();
    }

    public TypeMapper<A, B> _1() {
        return this.mapper();
    }

    public TypeSerializer<B> _2() {
        return this.ser();
    }

    public static class MappedSerializerSnapshot<A, B>
    implements TypeSerializerSnapshot<A> {
        private TypeMapper mapper;
        private TypeSerializer ser;

        public MappedSerializerSnapshot(TypeMapper<A, B> mapper, TypeSerializer<B> ser) {
            this.mapper = mapper;
            this.ser = ser;
        }

        public TypeMapper<A, B> mapper() {
            return this.mapper;
        }

        public void mapper_$eq(TypeMapper<A, B> x$1) {
            this.mapper = x$1;
        }

        public TypeSerializer<B> ser() {
            return this.ser;
        }

        public void ser_$eq(TypeSerializer<B> x$1) {
            this.ser = x$1;
        }

        public MappedSerializerSnapshot() {
            this(null, null);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) {
            Class mapperClazz = InstantiationUtil.resolveClassByName((DataInputView)in, (ClassLoader)userCodeClassLoader);
            this.mapper_$eq((TypeMapper)InstantiationUtil.instantiate((Class)mapperClazz));
            this.ser_$eq(TypeSerializerSnapshot.readVersionedSnapshot((DataInputView)in, (ClassLoader)userCodeClassLoader).restoreSerializer());
        }

        public TypeSerializerSchemaCompatibility<A> resolveSchemaCompatibility(TypeSerializerSnapshot<A> oldSerializerSnapshot) {
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }

        public void writeSnapshot(DataOutputView out) {
            out.writeUTF(this.mapper().getClass().getName());
            TypeSerializerSnapshot.writeVersionedSnapshot((DataOutputView)out, (TypeSerializerSnapshot)this.ser().snapshotConfiguration());
        }

        public TypeSerializer<A> restoreSerializer() {
            return new MappedSerializer<A, B>(this.mapper(), this.ser());
        }

        public int getCurrentVersion() {
            return 2;
        }
    }

    public static interface TypeMapper<A, B>
    extends Serializable {
        public B map(A var1);

        public A contramap(B var1);
    }
}

