/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flinkx.api.serializer;

import java.io.Serializable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flinkx.api.serializer.CollectionSerializerSnapshot;
import org.apache.flinkx.api.serializer.MutableSerializer;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;

public class SeqSerializer<T>
extends MutableSerializer<Seq<T>> {
    private final TypeSerializer<T> child;
    private final Class<T> clazz;
    private final boolean isImmutableType;

    public SeqSerializer(TypeSerializer<T> child, Class<T> clazz) {
        this.child = child;
        this.clazz = clazz;
        this.isImmutableType = child.isImmutableType();
    }

    public boolean isImmutableType() {
        return this.isImmutableType;
    }

    public Seq<T> copy(Seq<T> from) {
        if (from == null || this.isImmutableType()) {
            return from;
        }
        return (Seq)from.map((Function1 & Serializable)x$0 -> this.child.copy(x$0));
    }

    public SeqSerializer<T> duplicate() {
        TypeSerializer duplicatedChild = this.child.duplicate();
        if (duplicatedChild == this.child) {
            return this;
        }
        return new SeqSerializer<T>(duplicatedChild, this.clazz);
    }

    public Seq<T> createInstance() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public int getLength() {
        return -1;
    }

    public Seq<T> deserialize(DataInputView source) {
        int count = source.readInt();
        IndexedSeq result = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).map((Function1 & Serializable)x$1 -> this.$anonfun$1(source, BoxesRunTime.unboxToInt((Object)x$1)));
        return result;
    }

    public void serialize(Seq<T> record, DataOutputView target) {
        target.writeInt(record.size());
        record.foreach((Function1)(JProcedure1 & Serializable)element -> this.child.serialize(element, target));
    }

    public TypeSerializerSnapshot<Seq<T>> snapshotConfiguration() {
        return new CollectionSerializerSnapshot(this.child, SeqSerializer.class, this.clazz);
    }

    private final /* synthetic */ Object $anonfun$1(DataInputView source$1, int x$1) {
        int n = x$1;
        return this.child.deserialize(source$1);
    }
}

