/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flinkx.api.serializer;

import java.io.Serializable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flinkx.api.serializer.CollectionSerializerSnapshot;
import org.apache.flinkx.api.serializer.MutableSerializer;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;

public class SetSerializer<T>
extends MutableSerializer<Set<T>> {
    private final TypeSerializer<T> child;
    private final Class<T> clazz;
    private final boolean isImmutableType;

    public SetSerializer(TypeSerializer<T> child, Class<T> clazz) {
        this.child = child;
        this.clazz = clazz;
        this.isImmutableType = child.isImmutableType();
    }

    public boolean isImmutableType() {
        return this.isImmutableType;
    }

    public Set<T> copy(Set<T> from) {
        if (from == null || this.isImmutableType()) {
            return from;
        }
        return (Set)from.map((Function1 & Serializable)x$0 -> this.child.copy(x$0));
    }

    public SetSerializer<T> duplicate() {
        TypeSerializer duplicatedChild = this.child.duplicate();
        if (duplicatedChild == this.child) {
            return this;
        }
        return new SetSerializer<T>(duplicatedChild, this.clazz);
    }

    public Set<T> createInstance() {
        return Predef$.MODULE$.Set().empty();
    }

    public int getLength() {
        return -1;
    }

    public Set<T> deserialize(DataInputView source) {
        int count = source.readInt();
        IndexedSeq result = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).map((Function1 & Serializable)x$1 -> this.$anonfun$1(source, BoxesRunTime.unboxToInt((Object)x$1)));
        return result.toSet();
    }

    public void serialize(Set<T> record, DataOutputView target) {
        target.writeInt(record.size());
        record.foreach((Function1)(JProcedure1 & Serializable)element -> this.child.serialize(element, target));
    }

    public TypeSerializerSnapshot<Set<T>> snapshotConfiguration() {
        return new CollectionSerializerSnapshot(this.child, SetSerializer.class, this.clazz);
    }

    private final /* synthetic */ Object $anonfun$1(DataInputView source$1, int x$1) {
        int n = x$1;
        return this.child.deserialize(source$1);
    }
}

