/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flinkx.api.typeinfo;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.TupleComparatorBase;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.KeyFieldOutOfBoundsException;
import org.apache.flink.types.NullKeyFieldException;
import scala.Product;

@Internal
public class CaseClassComparator<T extends Product>
extends TupleComparatorBase<T> {
    private final Object[] extractedKeys;

    public CaseClassComparator(int[] keys, TypeComparator<?>[] scalaComparators, TypeSerializer<?>[] scalaSerializers) {
        super(keys, scalaComparators, scalaSerializers);
        this.extractedKeys = new Object[keys.length];
    }

    public Object[] extractedKeys() {
        return this.extractedKeys;
    }

    public TypeComparator<T> duplicate() {
        this.instantiateDeserializationUtils();
        CaseClassComparator<T> result = new CaseClassComparator<T>(this.keyPositions, this.comparators, this.serializers);
        result.privateDuplicate(this);
        return result;
    }

    public int hash(T value) {
        int i;
        TypeComparator comparator = this.comparators[0];
        int code = comparator.hash(value.productElement(this.keyPositions[0]));
        try {
            for (i = 1; i < this.keyPositions.length; ++i) {
                code *= TupleComparatorBase.HASH_SALT[i & 0x1F];
                TypeComparator comparator2 = this.comparators[i];
                code += comparator2.hash(value.productElement(this.keyPositions[i]));
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new NullKeyFieldException(this.keyPositions[i]);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new KeyFieldOutOfBoundsException(this.keyPositions[i]);
        }
        return code;
    }

    public void setReference(T toCompare) {
        int i;
        try {
            for (i = 0; i < this.keyPositions.length; ++i) {
                TypeComparator comparator = this.comparators[i];
                comparator.setReference(toCompare.productElement(this.keyPositions[i]));
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new NullKeyFieldException(this.keyPositions[i]);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new KeyFieldOutOfBoundsException(this.keyPositions[i]);
        }
    }

    public boolean equalToReference(T candidate) {
        int i;
        try {
            for (i = 0; i < this.keyPositions.length; ++i) {
                TypeComparator comparator = this.comparators[i];
                if (comparator.equalToReference(candidate.productElement(this.keyPositions[i]))) continue;
                return false;
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new NullKeyFieldException(this.keyPositions[i]);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new KeyFieldOutOfBoundsException(this.keyPositions[i]);
        }
        return true;
    }

    public int compare(T first, T second) {
        int i;
        try {
            for (i = 0; i < this.keyPositions.length; ++i) {
                TypeComparator comparator = this.comparators[i];
                int keyPos = this.keyPositions[i];
                int cmp = comparator.compare(first.productElement(keyPos), second.productElement(keyPos));
                if (cmp == 0) continue;
                return cmp;
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new NullKeyFieldException(this.keyPositions[i]);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new KeyFieldOutOfBoundsException(this.keyPositions[i]);
        }
        return 0;
    }

    public void putNormalizedKey(T value, MemorySegment target, int offsetParam, int numBytesParam) {
        int i;
        int numBytes = numBytesParam;
        int offset = offsetParam;
        try {
            for (i = 0; i < this.numLeadingNormalizableKeys && numBytes > 0; ++i) {
                int len = this.normalizedKeyLengths[i];
                len = numBytes >= len ? len : numBytes;
                TypeComparator comparator = this.comparators[i];
                comparator.putNormalizedKey(value.productElement(this.keyPositions[i]), target, offset, len);
                numBytes -= len;
                offset += len;
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new NullKeyFieldException(this.keyPositions[i]);
        }
    }

    public int extractKeys(Object value, Object[] target, int index) {
        Product in = (Product)value;
        int localIndex = index;
        for (int i = 0; i < this.comparators.length; ++i) {
            localIndex += this.comparators[i].extractKeys(in.productElement(this.keyPositions[i]), target, localIndex);
        }
        return localIndex - index;
    }
}

