/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flinkx.api.serializer;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializerBase;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.NullFieldException;
import org.apache.flinkx.api.serializer.CaseClassSerializer$;
import org.apache.flinkx.api.serializer.ConstructorCompat;
import org.apache.flinkx.api.serializer.ScalaCaseClassSerializerSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.immutable.IndexedSeq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Internal
public class CaseClassSerializer<T extends Product>
extends TupleSerializerBase<T>
implements Cloneable,
ConstructorCompat {
    private static final long serialVersionUID = 7341356073446263475L;
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(CaseClassSerializer.class.getDeclaredField("constructor$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CaseClassSerializer.class.getDeclaredField("log$lzy1"));
    private final boolean isCaseClassImmutable;
    private volatile transient Object log$lzy1;
    private final byte[] nullPadding;
    private final boolean isImmutableType;
    private final boolean isImmutableSerializer;
    private volatile transient Object constructor$lzy1;
    private final int getLength;

    public CaseClassSerializer(Class<T> clazz, TypeSerializer<?>[] scalaFieldSerializers, boolean isCaseClassImmutable) {
        Object object;
        this.isCaseClassImmutable = isCaseClassImmutable;
        super(clazz, scalaFieldSerializers);
        this.nullPadding = super.getLength() > 0 ? new byte[super.getLength()] : CaseClassSerializer$.org$apache$flinkx$api$serializer$CaseClassSerializer$$$EmptyByteArray;
        this.isImmutableType = isCaseClassImmutable && ArrayOps$.MODULE$.forall$extension(object = Predef$.MODULE$.refArrayOps((Object[])this.fieldSerializers), (Function1 & Serializable)_$1 -> _$1.isImmutableType());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])this.fieldSerializers);
        this.isImmutableSerializer = ArrayOps$.MODULE$.forall$extension(object2, (Function1 & Serializable)s -> s.duplicate() == s);
        this.getLength = super.getLength() == -1 ? -1 : super.getLength() + 4;
    }

    public boolean isCaseClassImmutable() {
        return this.isCaseClassImmutable;
    }

    private Logger log() {
        Object object = this.log$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger((Class)this.getClass());
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean isImmutableType() {
        return this.isImmutableType;
    }

    public boolean isImmutableSerializer() {
        return this.isImmutableSerializer;
    }

    private Function1<Object[], T> constructor() {
        Object object = this.constructor$lzy1;
        if (object instanceof Function1) {
            return (Function1)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Function1)this.constructor$lzyINIT1();
    }

    private Object constructor$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.constructor$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Function1 function1 = null;
                    try {
                        function1 = this.lookupConstructor(this.tupleClass);
                        object2 = function1 == null ? LazyVals.NullValue$.MODULE$ : function1;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.constructor$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return function1;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public CaseClassSerializer<T> duplicate() {
        if (this.isImmutableSerializer()) {
            return this;
        }
        return (CaseClassSerializer)this.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        CaseClassSerializer result = (CaseClassSerializer)super.clone();
        Object object = Predef$.MODULE$.refArrayOps((Object[])result.fieldSerializers);
        result.fieldSerializers = (TypeSerializer[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$2 -> _$2.duplicate(), ClassTag$.MODULE$.apply(TypeSerializer.class));
        return result;
    }

    public T createInstance() {
        T t;
        try {
            IndexedSeq fields = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.arity).map((Function1 & Serializable)i -> this.$anonfun$1(BoxesRunTime.unboxToInt((Object)i)));
            t = this.createInstance((Object[])fields.toArray(ClassTag$.MODULE$.apply(Object.class)));
        }
        catch (Throwable t2) {
            this.log().warn("Failed to create an instance returning null", t2);
            t = null;
        }
        return t;
    }

    public T createOrReuseInstance(Object[] fields, T reuse) {
        return this.createInstance(fields);
    }

    public T copy(T from, T reuse) {
        return this.copy(from);
    }

    public T copy(T from) {
        if (from == null || this.isImmutableType()) {
            return from;
        }
        IndexedSeq fields = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.arity).map((Function1 & Serializable)i -> this.$anonfun$2((Product)from, BoxesRunTime.unboxToInt((Object)i)));
        return this.createInstance((Object[])fields.toArray(ClassTag$.MODULE$.apply(Object.class)));
    }

    public int getLength() {
        return this.getLength;
    }

    public void serialize(T value, DataOutputView target) {
        int sourceArity = value == null ? -1 : this.arity;
        target.writeInt(sourceArity);
        if (value == null) {
            target.write(this.nullPadding);
        }
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), sourceArity).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            TypeSerializer serializer = this.fieldSerializers[i];
            Object o = value.productElement(i);
            try {
                serializer.serialize(o, target);
            }
            catch (NullPointerException e) {
                throw new NullFieldException(i, (Throwable)e);
            }
        });
    }

    public T deserialize(T reuse, DataInputView source) {
        return this.deserialize(source);
    }

    public T deserialize(DataInputView source) {
        int sourceArity = source.readInt();
        if (sourceArity == -1) {
            source.skipBytesToRead(this.nullPadding.length);
            return null;
        }
        Object[] fields = new Object[sourceArity];
        for (int i = 0; i < sourceArity; ++i) {
            fields[i] = this.fieldSerializers[i].deserialize(source);
        }
        return this.createInstance(fields);
    }

    public T createInstance(Object[] fields) {
        return (T)((Product)this.constructor().apply((Object)fields));
    }

    public TypeSerializerSnapshot<T> snapshotConfiguration() {
        return new ScalaCaseClassSerializerSnapshot(this);
    }

    private final /* synthetic */ Object $anonfun$1(int i) {
        return this.fieldSerializers[i].createInstance();
    }

    private final /* synthetic */ Object $anonfun$2(Product from$1, int i) {
        return this.fieldSerializers[i].copy(from$1.productElement(i));
    }
}

