/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.external.client.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.util.ISO8601Utils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.function.Function;
import org.flowable.external.client.AcquiredExternalWorkerJob;
import org.flowable.external.client.ExternalWorkerJobCompletionBuilder;
import org.flowable.external.client.FlowableClientException;
import org.flowable.external.client.impl.RestInvoker;
import org.flowable.external.client.impl.RestResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestExternalWorkerCompletionBuilder
implements ExternalWorkerJobCompletionBuilder {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final AcquiredExternalWorkerJob workerJob;
    protected final RestInvoker restInvoker;
    protected final ObjectMapper objectMapper;
    protected final ObjectNode request;

    public RestExternalWorkerCompletionBuilder(AcquiredExternalWorkerJob workerJob, RestInvoker restInvoker, ObjectMapper objectMapper) {
        this.workerJob = workerJob;
        this.restInvoker = restInvoker;
        this.objectMapper = objectMapper;
        this.request = objectMapper.createObjectNode().put("workerId", workerJob.getWorkerId());
    }

    @Override
    public ExternalWorkerJobCompletionBuilder variable(String name, String value) {
        return this.addVariableToRequest(name, "string", value, TextNode::valueOf);
    }

    @Override
    public ExternalWorkerJobCompletionBuilder variable(String name, Short value) {
        return this.addVariableToRequest(name, "short", value, ShortNode::valueOf);
    }

    @Override
    public ExternalWorkerJobCompletionBuilder variable(String name, Integer value) {
        return this.addVariableToRequest(name, "integer", value, IntNode::valueOf);
    }

    @Override
    public ExternalWorkerJobCompletionBuilder variable(String name, Long value) {
        return this.addVariableToRequest(name, "long", value, LongNode::valueOf);
    }

    @Override
    public ExternalWorkerJobCompletionBuilder variable(String name, Double value) {
        return this.addVariableToRequest(name, "double", value, DoubleNode::valueOf);
    }

    @Override
    public ExternalWorkerJobCompletionBuilder variable(String name, Boolean value) {
        return this.addVariableToRequest(name, "boolean", value, BooleanNode::valueOf);
    }

    @Override
    public ExternalWorkerJobCompletionBuilder variable(String name, Date value) {
        return this.addVariableToRequest(name, "date", value, v -> TextNode.valueOf((String)ISO8601Utils.format((Date)v)));
    }

    @Override
    public ExternalWorkerJobCompletionBuilder variable(String name, Instant value) {
        return this.addVariableToRequest(name, "instant", value, v -> TextNode.valueOf((String)v.toString()));
    }

    @Override
    public ExternalWorkerJobCompletionBuilder variable(String name, LocalDate value) {
        return this.addVariableToRequest(name, "localDate", value, v -> TextNode.valueOf((String)v.toString()));
    }

    @Override
    public ExternalWorkerJobCompletionBuilder variable(String name, LocalDateTime value) {
        return this.addVariableToRequest(name, "localDateTime", value, v -> TextNode.valueOf((String)v.toString()));
    }

    @Override
    public ExternalWorkerJobCompletionBuilder variable(String name, JsonNode value) {
        return this.addVariableToRequest(name, "json", value, Function.identity());
    }

    @Override
    public ExternalWorkerJobCompletionBuilder convertAndAddJsonVariable(String name, Object value) {
        return this.addVariableToRequest(name, "json", value, this::convertToJson);
    }

    protected <V> ExternalWorkerJobCompletionBuilder addVariableToRequest(String name, String type, V value, Function<V, JsonNode> valueMapper) {
        this.request.withArray("variables").addObject().put("name", name).put("type", type).set("value", (JsonNode)(value != null ? valueMapper.apply(value) : NullNode.getInstance()));
        return this;
    }

    protected JsonNode convertToJson(Object value) {
        try {
            String serializedValue = this.objectMapper.writeValueAsString(value);
            return this.objectMapper.readTree(serializedValue);
        }
        catch (JsonProcessingException e) {
            throw new FlowableClientException("Failed to convert value of type " + value.getClass().getName() + " to json", e);
        }
    }

    @Override
    public void complete() {
        this.sendRequest("complete");
    }

    @Override
    public void bpmnError() {
        this.bpmnError(null);
    }

    @Override
    public void bpmnError(String errorCode) {
        if (!"bpmn".equals(this.workerJob.getScopeType())) {
            throw new FlowableClientException("Completing " + this.workerJob.getScopeType() + " external worker job with bpmn error is not allowed");
        }
        if (errorCode != null) {
            this.request.put("errorCode", errorCode);
        }
        this.sendRequest("bpmnError");
    }

    @Override
    public void cmmnTerminate() {
        if (!"cmmn".equals(this.workerJob.getScopeType())) {
            throw new FlowableClientException("Completing " + this.workerJob.getScopeType() + " external worker job with cmmn terminate is not allowed");
        }
        this.sendRequest("cmmnTerminate");
    }

    protected void sendRequest(String action) {
        String workerJobId = this.workerJob.getId();
        this.logger.debug("Sending complete request for job {} with worker {}", (Object)workerJobId, (Object)this.workerJob.getWorkerId());
        RestResponse<String> response = this.restInvoker.post("/acquire/jobs/" + workerJobId + "/" + action, this.request);
        int statusCode = response.statusCode();
        if (statusCode != 204) {
            throw new FlowableClientException("Completing a job failed with status " + statusCode + " and body: " + response.body());
        }
        this.logger.debug("Successfully completed job {}", (Object)workerJobId);
    }
}

