/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.external.client.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.time.Duration;
import org.flowable.external.client.AcquiredExternalWorkerJob;
import org.flowable.external.client.ExternalWorkerJobFailureBuilder;
import org.flowable.external.client.FlowableClientException;
import org.flowable.external.client.impl.RestInvoker;
import org.flowable.external.client.impl.RestResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestExternalWorkerFailureBuilder
implements ExternalWorkerJobFailureBuilder {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final AcquiredExternalWorkerJob workerJob;
    protected final RestInvoker restInvoker;
    protected final ObjectNode request;

    public RestExternalWorkerFailureBuilder(AcquiredExternalWorkerJob workerJob, RestInvoker restInvoker, ObjectMapper objectMapper) {
        this.workerJob = workerJob;
        this.restInvoker = restInvoker;
        this.request = objectMapper.createObjectNode().put("workerId", workerJob.getWorkerId());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExternalWorkerJobFailureBuilder error(Exception exception) {
        this.message(exception.getMessage());
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter(sw);
            try {
                exception.printStackTrace(pw);
                this.details(sw.getBuffer().toString());
                RestExternalWorkerFailureBuilder restExternalWorkerFailureBuilder = this;
                pw.close();
                return restExternalWorkerFailureBuilder;
            }
            catch (Throwable throwable) {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public ExternalWorkerJobFailureBuilder message(String message) {
        this.request.put("errorMessage", message);
        return this;
    }

    @Override
    public ExternalWorkerJobFailureBuilder details(String details) {
        this.request.put("errorDetails", details);
        return this;
    }

    @Override
    public ExternalWorkerJobFailureBuilder retries(int retries) {
        this.request.put("retries", retries);
        return this;
    }

    @Override
    public ExternalWorkerJobFailureBuilder retryTimeout(Duration retryTimeout) {
        this.request.put("retryTimeout", retryTimeout.toString());
        return this;
    }

    @Override
    public void fail() {
        this.sendRequest();
    }

    protected void sendRequest() {
        String workerJobId = this.workerJob.getId();
        this.logger.debug("Sending fail request for job {} with worker {}", (Object)workerJobId, (Object)this.workerJob.getWorkerId());
        RestResponse<String> response = this.restInvoker.post("/acquire/jobs/" + workerJobId + "/fail", this.request);
        int statusCode = response.statusCode();
        if (statusCode != 204) {
            throw new FlowableClientException("Failing a job failed with status " + statusCode + " and body: " + response.body());
        }
        this.logger.debug("Successfully failed job {}", (Object)workerJobId);
    }
}

