/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.external.client.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.ISO8601Utils;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;
import org.flowable.external.client.AcquiredExternalWorkerJob;
import org.flowable.external.client.FlowableClientException;
import org.flowable.external.client.impl.BaseAcquiredExternalWorkerJob;
import org.flowable.external.client.impl.BaseExternalWorkerJobAcquireBuilder;
import org.flowable.external.client.impl.RestInvoker;
import org.flowable.external.client.impl.RestResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestExternalWorkerJobAcquireBuilder
extends BaseExternalWorkerJobAcquireBuilder {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String workerId;
    protected final RestInvoker restInvoker;
    protected final ObjectMapper objectMapper;

    public RestExternalWorkerJobAcquireBuilder(String workerId, RestInvoker restInvoker, ObjectMapper objectMapper) {
        this.workerId = workerId;
        this.restInvoker = restInvoker;
        this.objectMapper = objectMapper;
    }

    @Override
    protected List<AcquiredExternalWorkerJob> acquireAndLockInternal() {
        ObjectNode request = this.prepareRequest();
        return this.sendRequestAndAcquire(request);
    }

    protected ObjectNode prepareRequest() {
        ObjectNode request = this.objectMapper.createObjectNode().put("topic", this.topic).put("workerId", this.workerId);
        if (this.lockDuration != null) {
            request.put("lockDuration", this.lockDuration.toString());
        }
        if (this.scopeType != null) {
            request.put("scopeType", this.scopeType);
        }
        if (this.numberOfTasks > 0) {
            request.put("numberOfTasks", this.numberOfTasks);
        }
        if (this.numberOfRetries > 0) {
            request.put("numberOfRetries", this.numberOfRetries);
        }
        return request;
    }

    protected List<AcquiredExternalWorkerJob> sendRequestAndAcquire(ObjectNode requestBody) {
        this.logger.debug("Acquiring jobs for worker {}", (Object)this.workerId);
        RestResponse<String> response = this.restInvoker.post("/acquire/jobs", requestBody);
        int statusCode = response.statusCode();
        String responseBody = response.body();
        if (statusCode == 200) {
            this.logger.debug("Acquired jobs for worker {}. Response: {}", (Object)this.workerId, (Object)responseBody);
            return this.asList(responseBody);
        }
        throw new FlowableClientException("Acquiring jobs failed with status " + statusCode + " and body: " + responseBody);
    }

    protected List<AcquiredExternalWorkerJob> asList(String response) {
        try {
            ArrayNode jobsNode = (ArrayNode)this.objectMapper.readValue(response, ArrayNode.class);
            ArrayList<AcquiredExternalWorkerJob> jobs = new ArrayList<AcquiredExternalWorkerJob>(jobsNode.size());
            for (JsonNode jobNode : jobsNode) {
                if (!jobNode.isObject()) continue;
                jobs.add(this.asJob((ObjectNode)jobNode));
            }
            return jobs;
        }
        catch (JsonProcessingException e) {
            throw new FlowableClientException("Failed to read response", e);
        }
    }

    protected AcquiredExternalWorkerJob asJob(ObjectNode jobNode) {
        BaseAcquiredExternalWorkerJob job = new BaseAcquiredExternalWorkerJob();
        job.setId(jobNode.path("id").asText(null));
        job.setCorrelationId(jobNode.path("correlationId").asText(null));
        job.setRetries(jobNode.path("retries").asInt(0));
        if (jobNode.hasNonNull("processInstanceId")) {
            job.setScopeId(jobNode.path("processInstanceId").asText(null));
            job.setScopeType("bpmn");
            job.setSubScopeId(jobNode.path("executionId").asText(null));
            job.setScopeDefinitionId(jobNode.path("processDefinitionId").asText(null));
        } else {
            job.setScopeId(jobNode.path("scopeId").asText(null));
            job.setScopeType(jobNode.path("scopeType").asText(null));
            job.setSubScopeId(jobNode.path("subScopeId").asText(null));
            job.setScopeDefinitionId(jobNode.path("scopeDefinitionId").asText(null));
        }
        job.setTenantId(jobNode.path("tenantId").asText(null));
        job.setElementId(jobNode.path("elementId").asText(null));
        job.setElementName(jobNode.path("elementName").asText(null));
        job.setExceptionMessage(jobNode.path("exceptionMessage").asText(null));
        job.setCreateTime(this.asInstant(jobNode.path("createTime").asText(null)));
        job.setDueDate(this.asInstant(jobNode.path("dueDate").asText(null)));
        job.setWorkerId(jobNode.path("lockOwner").asText(null));
        job.setLockExpirationTime(this.asInstant(jobNode.path("lockExpirationTime").asText(null)));
        JsonNode variablesNode = jobNode.path("variables");
        if (variablesNode.isArray() && !variablesNode.isEmpty()) {
            this.parseVariables((ArrayNode)variablesNode, job::addVariable);
        }
        return job;
    }

    protected Instant asInstant(String value) {
        if (value == null) {
            return null;
        }
        return Instant.parse(value);
    }

    protected void parseVariables(ArrayNode variablesNode, BiConsumer<String, Object> variableConsumer) {
        for (JsonNode variableNode : variablesNode) {
            String variableName = variableNode.path("name").asText(null);
            if (variableName == null || variableName.isEmpty()) continue;
            String type = variableNode.path("type").asText(null);
            JsonNode valueNode = variableNode.path("value");
            variableConsumer.accept(variableName, this.parseVariableValue(type, valueNode));
        }
    }

    protected Object parseVariableValue(String type, JsonNode valueNode) {
        if (valueNode.isMissingNode() || valueNode.isNull() || type == null) {
            return null;
        }
        return switch (type) {
            case "string" -> {
                String var5_5 = valueNode.textValue();
                yield var5_5;
            }
            case "json" -> {
                JsonNode var5_6;
                yield var5_6 = valueNode;
            }
            case "boolean" -> {
                Boolean var5_7 = valueNode.booleanValue();
                yield var5_7;
            }
            case "double" -> {
                Double var5_8 = valueNode.doubleValue();
                yield var5_8;
            }
            case "long" -> {
                Long var5_9 = valueNode.longValue();
                yield var5_9;
            }
            case "date" -> {
                try {
                    Date var5_10 = ISO8601Utils.parse((String)valueNode.textValue(), (ParsePosition)new ParsePosition(0));
                    yield var5_10;
                }
                catch (ParseException e) {
                    Object var5_11 = null;
                    yield var5_11;
                }
            }
            case "instant" -> {
                Instant var5_12 = Instant.parse(valueNode.textValue());
                yield var5_12;
            }
            case "localDate" -> {
                LocalDate var5_13 = LocalDate.parse(valueNode.textValue());
                yield var5_13;
            }
            case "localDateTime" -> {
                LocalDateTime var5_14 = LocalDateTime.parse(valueNode.textValue());
                yield var5_14;
            }
            case "short" -> {
                Short var5_15 = valueNode.shortValue();
                yield var5_15;
            }
            case "integer" -> {
                Integer var5_16 = valueNode.intValue();
                yield var5_16;
            }
            default -> {
                this.logger.warn("Cannot parse variable type {}", (Object)type);
                Object var5_17 = null;
                yield var5_17;
            }
        };
    }
}

