/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.cmd;

import org.flowable.app.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.variable.service.VariableService;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class RemoveVariableCmd
implements Command<Void> {
    protected String appDefinitionId;
    protected String variableName;

    public RemoveVariableCmd(String appDefinitionId, String variableName) {
        this.appDefinitionId = appDefinitionId;
        this.variableName = variableName;
    }

    public Void execute(CommandContext commandContext) {
        if (this.appDefinitionId == null) {
            throw new FlowableIllegalArgumentException("appDefinitionId is null");
        }
        if (this.variableName == null) {
            throw new FlowableIllegalArgumentException("variableName is null");
        }
        VariableService variableService = CommandContextUtil.getVariableService(commandContext);
        VariableInstanceEntity variableInstance = variableService.findVariableInstanceByScopeIdAndScopeTypeAndName(this.appDefinitionId, "app", this.variableName);
        if (variableInstance == null) {
            throw new FlowableException("Variable not found");
        }
        variableService.deleteVariableInstance(variableInstance);
        return null;
    }
}

