/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl;

import org.flowable.app.api.AppManagementService;
import org.flowable.app.api.AppRepositoryService;
import org.flowable.app.engine.AppEngine;
import org.flowable.app.engine.AppEngineConfiguration;
import org.flowable.app.engine.AppEngines;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppEngineImpl
implements AppEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppEngineImpl.class);
    protected String name;
    protected AppEngineConfiguration appEngineConfiguration;
    protected AppManagementService appManagementService;
    protected AppRepositoryService appRepositoryService;

    public AppEngineImpl(AppEngineConfiguration appEngineConfiguration) {
        this.appEngineConfiguration = appEngineConfiguration;
        this.name = appEngineConfiguration.getEngineName();
        this.appManagementService = appEngineConfiguration.getAppManagementService();
        this.appRepositoryService = appEngineConfiguration.getAppRepositoryService();
        if (appEngineConfiguration.getSchemaManagementCmd() != null) {
            CommandExecutor commandExecutor = appEngineConfiguration.getCommandExecutor();
            commandExecutor.execute(appEngineConfiguration.getSchemaCommandConfig(), appEngineConfiguration.getSchemaManagementCmd());
        }
        LOGGER.info("AppEngine {} created", (Object)this.name);
        AppEngines.registerAppEngine(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void close() {
        AppEngines.unregister(this);
    }

    @Override
    public AppEngineConfiguration getAppEngineConfiguration() {
        return this.appEngineConfiguration;
    }

    public void setAppEngineConfiguration(AppEngineConfiguration appEngineConfiguration) {
        this.appEngineConfiguration = appEngineConfiguration;
    }

    @Override
    public AppManagementService getAppManagementService() {
        return this.appManagementService;
    }

    public void setAppManagementService(AppManagementService appManagementService) {
        this.appManagementService = appManagementService;
    }

    @Override
    public AppRepositoryService getAppRepositoryService() {
        return this.appRepositoryService;
    }

    public void setAppRepositoryService(AppRepositoryService appRepositoryService) {
        this.appRepositoryService = appRepositoryService;
    }
}

