/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.flowable.app.api.repository.AppDeployment;
import org.flowable.app.api.repository.AppDeploymentBuilder;
import org.flowable.app.engine.AppEngineConfiguration;
import org.flowable.app.engine.impl.AppRepositoryServiceImpl;
import org.flowable.app.engine.impl.persistence.entity.AppDeploymentEntity;
import org.flowable.app.engine.impl.persistence.entity.AppResourceEntity;
import org.flowable.app.engine.impl.persistence.entity.AppResourceEntityManager;
import org.flowable.app.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.util.IoUtil;

public class AppDeploymentBuilderImpl
implements AppDeploymentBuilder {
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected transient AppRepositoryServiceImpl repositoryService;
    protected transient AppResourceEntityManager resourceEntityManager;
    protected AppDeploymentEntity deployment;
    protected boolean isXsdValidationEnabled = true;
    protected boolean isDuplicateFilterEnabled;

    public AppDeploymentBuilderImpl() {
        AppEngineConfiguration appEngineConfiguration = CommandContextUtil.getAppEngineConfiguration();
        this.repositoryService = (AppRepositoryServiceImpl)appEngineConfiguration.getAppRepositoryService();
        this.deployment = (AppDeploymentEntity)appEngineConfiguration.getAppDeploymentEntityManager().create();
        this.resourceEntityManager = appEngineConfiguration.getAppResourceEntityManager();
    }

    public AppDeploymentBuilder addInputStream(String resourceName, InputStream inputStream) {
        if (inputStream == null) {
            throw new FlowableException("inputStream for resource '" + resourceName + "' is null");
        }
        byte[] bytes = null;
        try {
            bytes = IoUtil.readInputStream((InputStream)inputStream, (String)resourceName);
        }
        catch (Exception e) {
            throw new FlowableException("could not get byte array from resource '" + resourceName + "'", (Throwable)e);
        }
        if (bytes == null) {
            throw new FlowableException("byte array for resource '" + resourceName + "' is null");
        }
        AppResourceEntity resource = (AppResourceEntity)this.resourceEntityManager.create();
        resource.setName(resourceName);
        resource.setBytes(bytes);
        this.deployment.addResource(resource);
        return this;
    }

    public AppDeploymentBuilder addClasspathResource(String resource) {
        AppDeploymentBuilder appDeploymentBuilder;
        block9: {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(resource);
            try {
                if (inputStream == null) {
                    throw new FlowableException("resource '" + resource + "' not found");
                }
                appDeploymentBuilder = this.addInputStream(resource, inputStream);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new FlowableException("Failed to read resource " + resource, (Throwable)ex);
                }
            }
            inputStream.close();
        }
        return appDeploymentBuilder;
    }

    public AppDeploymentBuilder addString(String resourceName, String text) {
        if (text == null) {
            throw new FlowableException("text is null");
        }
        AppResourceEntity resource = (AppResourceEntity)this.resourceEntityManager.create();
        resource.setName(resourceName);
        try {
            resource.setBytes(text.getBytes(DEFAULT_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new FlowableException("Unable to get bytes.", (Throwable)e);
        }
        this.deployment.addResource(resource);
        return this;
    }

    public AppDeploymentBuilder addBytes(String resourceName, byte[] bytes) {
        if (bytes == null) {
            throw new FlowableException("bytes array is null");
        }
        AppResourceEntity resource = (AppResourceEntity)this.resourceEntityManager.create();
        resource.setName(resourceName);
        resource.setBytes(bytes);
        this.deployment.addResource(resource);
        return this;
    }

    public AppDeploymentBuilder addZipInputStream(ZipInputStream zipInputStream) {
        try {
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    String entryName = entry.getName();
                    byte[] bytes = IoUtil.readInputStream((InputStream)zipInputStream, (String)entryName);
                    AppResourceEntity resource = (AppResourceEntity)this.resourceEntityManager.create();
                    resource.setName(entryName);
                    resource.setBytes(bytes);
                    this.deployment.addResource(resource);
                }
                entry = zipInputStream.getNextEntry();
            }
        }
        catch (Exception e) {
            throw new FlowableException("problem reading zip input stream", (Throwable)e);
        }
        return this;
    }

    public AppDeploymentBuilder name(String name) {
        this.deployment.setName(name);
        return this;
    }

    public AppDeploymentBuilder category(String category) {
        this.deployment.setCategory(category);
        return this;
    }

    public AppDeploymentBuilder key(String key) {
        this.deployment.setKey(key);
        return this;
    }

    public AppDeploymentBuilder disableSchemaValidation() {
        this.isXsdValidationEnabled = false;
        return this;
    }

    public AppDeploymentBuilder tenantId(String tenantId) {
        this.deployment.setTenantId(tenantId);
        return this;
    }

    public AppDeploymentBuilder enableDuplicateFiltering() {
        this.isDuplicateFilterEnabled = true;
        return this;
    }

    public AppDeployment deploy() {
        return this.repositoryService.deploy(this);
    }

    public AppDeploymentEntity getDeployment() {
        return this.deployment;
    }

    public boolean isXsdValidationEnabled() {
        return this.isXsdValidationEnabled;
    }

    public boolean isDuplicateFilterEnabled() {
        return this.isDuplicateFilterEnabled;
    }
}

