/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.db;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.app.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.db.EngineSchemaManagerLockConfiguration;
import org.flowable.common.engine.impl.db.EngineSqlScriptBasedDbSchemaManager;
import org.flowable.common.engine.impl.db.SchemaManagerLockConfiguration;

public class AppDbSchemaManager
extends EngineSqlScriptBasedDbSchemaManager {
    protected static final String APP_DB_SCHEMA_LOCK_NAME = "appDbSchemaLock";
    protected static final Map<String, String> changeLogVersionMap = Map.ofEntries(Map.entry("1", "6.3.1.0"), Map.entry("2", "6.4.0.0"), Map.entry("3", "6.4.1.3"));

    public AppDbSchemaManager() {
        super("app", (SchemaManagerLockConfiguration)new EngineSchemaManagerLockConfiguration(CommandContextUtil::getAppEngineConfiguration));
    }

    protected String getEngineVersion() {
        return "7.2.0.2";
    }

    protected String getSchemaVersionPropertyName() {
        return "app.schema.version";
    }

    protected String getDbSchemaLockName() {
        return APP_DB_SCHEMA_LOCK_NAME;
    }

    protected String getEngineTableName() {
        return "ACT_APP_DEPLOYMENT";
    }

    protected String getChangeLogTableName() {
        return "ACT_APP_DATABASECHANGELOG";
    }

    protected String getDbVersionForChangelogVersion(String changeLogVersion) {
        if (StringUtils.isNotEmpty((CharSequence)changeLogVersion) && changeLogVersionMap.containsKey(changeLogVersion)) {
            return changeLogVersionMap.get(changeLogVersion);
        }
        return "6.3.0.1";
    }

    protected String getResourcesRootDirectory() {
        return "org/flowable/app/db/";
    }
}

