/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter;

import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.converter.BaseBpmnXMLConverter;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.BusinessRuleTask;
import org.apache.commons.lang3.StringUtils;

public class BusinessRuleTaskXMLConverter
extends BaseBpmnXMLConverter {
    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return BusinessRuleTask.class;
    }

    @Override
    protected String getXMLElementName() {
        return "businessRuleTask";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        BusinessRuleTask businessRuleTask = new BusinessRuleTask();
        BpmnXMLUtil.addXMLLocation((BaseElement)businessRuleTask, xtr);
        businessRuleTask.setInputVariables(this.parseDelimitedList(BpmnXMLUtil.getAttributeValue("ruleVariablesInput", xtr)));
        businessRuleTask.setRuleNames(this.parseDelimitedList(BpmnXMLUtil.getAttributeValue("rules", xtr)));
        businessRuleTask.setResultVariableName(BpmnXMLUtil.getAttributeValue("resultVariable", xtr));
        businessRuleTask.setClassName(BpmnXMLUtil.getAttributeValue("class", xtr));
        String exclude = BpmnXMLUtil.getAttributeValue("exclude", xtr);
        if ("true".equalsIgnoreCase(exclude)) {
            businessRuleTask.setExclude(true);
        }
        this.parseChildElements(this.getXMLElementName(), (BaseElement)businessRuleTask, model, xtr);
        return businessRuleTask;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        String ruleNames;
        BusinessRuleTask businessRuleTask = (BusinessRuleTask)element;
        String inputVariables = this.convertToDelimitedString(businessRuleTask.getInputVariables());
        if (StringUtils.isNotEmpty((CharSequence)inputVariables)) {
            this.writeQualifiedAttribute("ruleVariablesInput", inputVariables, xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)(ruleNames = this.convertToDelimitedString(businessRuleTask.getRuleNames())))) {
            this.writeQualifiedAttribute("rules", ruleNames, xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)businessRuleTask.getResultVariableName())) {
            this.writeQualifiedAttribute("resultVariable", businessRuleTask.getResultVariableName(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)businessRuleTask.getClassName())) {
            this.writeQualifiedAttribute("class", businessRuleTask.getClassName(), xtw);
        }
        if (businessRuleTask.isExclude()) {
            this.writeQualifiedAttribute("exclude", "true", xtw);
        }
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
    }
}

