/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter;

import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.converter.BaseBpmnXMLConverter;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.alfresco.AlfrescoStartEvent;
import org.apache.commons.lang3.StringUtils;

public class StartEventXMLConverter
extends BaseBpmnXMLConverter {
    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return StartEvent.class;
    }

    @Override
    protected String getXMLElementName() {
        return "startEvent";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        String formKey = BpmnXMLUtil.getAttributeValue("formKey", xtr);
        StartEvent startEvent = null;
        if (StringUtils.isNotEmpty((CharSequence)formKey) && model.getStartEventFormTypes() != null && model.getStartEventFormTypes().contains(formKey)) {
            startEvent = new AlfrescoStartEvent();
        }
        if (startEvent == null) {
            startEvent = new StartEvent();
        }
        BpmnXMLUtil.addXMLLocation(startEvent, xtr);
        startEvent.setInitiator(BpmnXMLUtil.getAttributeValue("initiator", xtr));
        startEvent.setFormKey(formKey);
        this.parseChildElements(this.getXMLElementName(), (BaseElement)startEvent, model, xtr);
        return startEvent;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        StartEvent startEvent = (StartEvent)element;
        this.writeQualifiedAttribute("initiator", startEvent.getInitiator(), xtw);
        this.writeQualifiedAttribute("formKey", startEvent.getFormKey(), xtw);
    }

    @Override
    protected boolean writeExtensionChildElements(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        StartEvent startEvent = (StartEvent)element;
        didWriteExtensionStartElement = this.writeFormProperties((FlowElement)startEvent, didWriteExtensionStartElement, xtw);
        return didWriteExtensionStartElement;
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        StartEvent startEvent = (StartEvent)element;
        this.writeEventDefinitions((Event)startEvent, startEvent.getEventDefinitions(), model, xtw);
    }
}

