/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.export;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.constants.BpmnXMLConstants;
import org.flowable.bpmn.model.Artifact;
import org.flowable.bpmn.model.Association;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.bpmn.model.MessageFlow;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.SubProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPMNDIExport
implements BpmnXMLConstants {
    private static final Logger logger = LoggerFactory.getLogger(BPMNDIExport.class);

    public static void writeBPMNDI(BpmnModel model, XMLStreamWriter xtw) throws Exception {
        FlowElement flowElement;
        xtw.writeStartElement("bpmndi", "BPMNDiagram", "http://www.omg.org/spec/BPMN/20100524/DI");
        String processId = null;
        processId = !model.getPools().isEmpty() ? "Collaboration" : model.getMainProcess().getId();
        HashMap<String, SubProcess> collapsedSubProcessMap = new HashMap<String, SubProcess>();
        HashMap<String, String> collapsedSubProcessChildren = new HashMap<String, String>();
        for (String string : model.getLocationMap().keySet()) {
            String flowId;
            GraphicInfo gi;
            Boolean isExpanded;
            flowElement = model.getFlowElement(string);
            if (!(flowElement instanceof SubProcess) || (isExpanded = (gi = model.getGraphicInfo(flowId = flowElement.getId())).getExpanded()) == null || isExpanded.booleanValue()) continue;
            SubProcess subProcess = (SubProcess)flowElement;
            for (FlowElement element : subProcess.getFlowElements()) {
                collapsedSubProcessChildren.put(element.getId(), string);
            }
            collapsedSubProcessMap.put(string, subProcess);
        }
        for (String string : model.getFlowLocationMap().keySet()) {
            Artifact artifact;
            flowElement = model.getFlowElement(string);
            String belongsTo = null;
            if (flowElement instanceof SequenceFlow) {
                SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
                belongsTo = (String)collapsedSubProcessChildren.get(sequenceFlow.getTargetRef());
            } else if (flowElement == null && (artifact = model.getArtifact(string)) instanceof Association) {
                Association association = (Association)artifact;
                belongsTo = (String)collapsedSubProcessChildren.get(association.getTargetRef());
            }
            if (belongsTo == null) continue;
            collapsedSubProcessChildren.put(string, belongsTo);
        }
        xtw.writeAttribute("id", "BPMNDiagram_" + processId);
        xtw.writeStartElement("bpmndi", "BPMNPlane", "http://www.omg.org/spec/BPMN/20100524/DI");
        xtw.writeAttribute("bpmnElement", processId);
        xtw.writeAttribute("id", "BPMNPlane_" + processId);
        for (String string : model.getLocationMap().keySet()) {
            if (collapsedSubProcessChildren.get(string) != null) {
                logger.debug("{} belongs to collapsed subprocess {}", (Object)string, collapsedSubProcessChildren.get(string));
                continue;
            }
            if (model.getFlowElement(string) == null && model.getArtifact(string) == null && model.getPool(string) == null && model.getLane(string) == null) continue;
            BPMNDIExport.createBpmnShape(model, string, xtw);
        }
        for (String string : model.getFlowLocationMap().keySet()) {
            if (collapsedSubProcessChildren.get(string) != null) {
                logger.info("{} belongs to collapsed subprocess {}", (Object)string, collapsedSubProcessChildren.get(string));
                continue;
            }
            if (model.getFlowElement(string) == null && model.getArtifact(string) == null && model.getMessageFlow(string) == null) continue;
            BPMNDIExport.createBpmnEdge(model, string, xtw);
        }
        xtw.writeEndElement();
        xtw.writeEndElement();
        for (Map.Entry entry : collapsedSubProcessMap.entrySet()) {
            xtw.writeStartElement("bpmndi", "BPMNDiagram", "http://www.omg.org/spec/BPMN/20100524/DI");
            xtw.writeAttribute("id", "BPMNDiagram_" + (String)entry.getKey());
            xtw.writeStartElement("bpmndi", "BPMNPlane", "http://www.omg.org/spec/BPMN/20100524/DI");
            xtw.writeAttribute("bpmnElement", (String)entry.getKey());
            xtw.writeAttribute("id", "BPMNPlane_" + (String)entry.getKey());
            SubProcess collapsedSubProcess = (SubProcess)entry.getValue();
            for (FlowElement child : collapsedSubProcess.getFlowElements()) {
                if (child instanceof SequenceFlow) {
                    BPMNDIExport.createBpmnEdge(model, child.getId(), xtw);
                    continue;
                }
                GraphicInfo graphicInfo = model.getGraphicInfo(child.getId());
                if (graphicInfo == null) continue;
                BPMNDIExport.createBpmnShape(model, child.getId(), xtw);
            }
            xtw.writeEndElement();
            xtw.writeEndElement();
        }
    }

    protected static void createBpmnShape(BpmnModel model, String elementId, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("bpmndi", "BPMNShape", "http://www.omg.org/spec/BPMN/20100524/DI");
        xtw.writeAttribute("bpmnElement", elementId);
        xtw.writeAttribute("id", "BPMNShape_" + elementId);
        GraphicInfo graphicInfo = model.getGraphicInfo(elementId);
        FlowElement flowElement = model.getFlowElement(elementId);
        if (flowElement instanceof SubProcess && graphicInfo.getExpanded() != null) {
            xtw.writeAttribute("isExpanded", String.valueOf(graphicInfo.getExpanded()));
        }
        xtw.writeStartElement("omgdc", "Bounds", "http://www.omg.org/spec/DD/20100524/DC");
        xtw.writeAttribute("height", String.valueOf(graphicInfo.getHeight()));
        xtw.writeAttribute("width", String.valueOf(graphicInfo.getWidth()));
        xtw.writeAttribute("x", String.valueOf(graphicInfo.getX()));
        xtw.writeAttribute("y", String.valueOf(graphicInfo.getY()));
        xtw.writeEndElement();
        xtw.writeEndElement();
    }

    protected static void createBpmnEdge(BpmnModel model, String elementId, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("bpmndi", "BPMNEdge", "http://www.omg.org/spec/BPMN/20100524/DI");
        xtw.writeAttribute("bpmnElement", elementId);
        xtw.writeAttribute("id", "BPMNEdge_" + elementId);
        List graphicInfoList = model.getFlowLocationGraphicInfo(elementId);
        for (GraphicInfo graphicInfo : graphicInfoList) {
            xtw.writeStartElement("omgdi", "waypoint", "http://www.omg.org/spec/DD/20100524/DI");
            xtw.writeAttribute("x", String.valueOf(graphicInfo.getX()));
            xtw.writeAttribute("y", String.valueOf(graphicInfo.getY()));
            xtw.writeEndElement();
        }
        GraphicInfo labelGraphicInfo = model.getLabelGraphicInfo(elementId);
        FlowElement flowElement = model.getFlowElement(elementId);
        MessageFlow messageFlow = null;
        if (flowElement == null) {
            messageFlow = model.getMessageFlow(elementId);
        }
        boolean hasName = false;
        if (flowElement != null && StringUtils.isNotEmpty((CharSequence)flowElement.getName())) {
            hasName = true;
        } else if (messageFlow != null && StringUtils.isNotEmpty((CharSequence)messageFlow.getName())) {
            hasName = true;
        }
        if (labelGraphicInfo != null && hasName) {
            xtw.writeStartElement("bpmndi", "BPMNLabel", "http://www.omg.org/spec/BPMN/20100524/DI");
            xtw.writeStartElement("omgdc", "Bounds", "http://www.omg.org/spec/DD/20100524/DC");
            xtw.writeAttribute("height", String.valueOf(labelGraphicInfo.getHeight()));
            xtw.writeAttribute("width", String.valueOf(labelGraphicInfo.getWidth()));
            xtw.writeAttribute("x", String.valueOf(labelGraphicInfo.getX()));
            xtw.writeAttribute("y", String.valueOf(labelGraphicInfo.getY()));
            xtw.writeEndElement();
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }
}

