/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.converter.IndentingXMLStreamWriter;
import org.flowable.bpmn.converter.export.BPMNDIExport;
import org.flowable.bpmn.converter.export.CollaborationExport;
import org.flowable.bpmn.converter.export.DataStoreExport;
import org.flowable.bpmn.converter.export.DefinitionsRootExport;
import org.flowable.bpmn.converter.export.ProcessExport;
import org.flowable.bpmn.converter.export.SignalAndMessageDefinitionExport;
import org.flowable.bpmn.exceptions.XMLException;
import org.flowable.bpmn.model.Artifact;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.DataObject;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.SubProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubprocessXMLConverter
extends BpmnXMLConverter {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SubprocessXMLConverter.class);

    @Override
    public byte[] convertToXML(BpmnModel model, String encoding) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)outputStream, encoding);
            XMLStreamWriter writer = xof.createXMLStreamWriter(out);
            IndentingXMLStreamWriter xtw = new IndentingXMLStreamWriter(writer);
            DefinitionsRootExport.writeRootElement(model, xtw, encoding);
            CollaborationExport.writePools(model, xtw);
            DataStoreExport.writeDataStores(model, xtw);
            SignalAndMessageDefinitionExport.writeSignalsAndMessages(model, xtw);
            for (Object process : model.getProcesses()) {
                if (process.getFlowElements().isEmpty() && process.getLanes().isEmpty()) continue;
                ProcessExport.writeProcess((Process)process, xtw);
                for (FlowElement flowElement : process.getFlowElements()) {
                    this.createXML(flowElement, model, (XMLStreamWriter)xtw);
                }
                for (Artifact artifact : process.getArtifacts()) {
                    this.createXML(artifact, model, (XMLStreamWriter)xtw);
                }
                xtw.writeEndElement();
            }
            List<BpmnModel> subModels = this.parseSubModels(model);
            for (BpmnModel tempModel : subModels) {
                if (tempModel.getFlowLocationMap().isEmpty() && tempModel.getLocationMap().isEmpty()) continue;
                BPMNDIExport.writeBPMNDI(tempModel, xtw);
            }
            xtw.writeEndElement();
            xtw.writeEndDocument();
            xtw.flush();
            byte[] bytes = (byte[])outputStream.toByteArray().clone();
            outputStream.close();
            xtw.close();
            return bytes;
        }
        catch (Exception e) {
            LOGGER.error("Error writing BPMN XML", (Throwable)e);
            throw new XMLException("Error writing BPMN XML", e);
        }
    }

    protected List<BpmnModel> parseSubModels(BpmnModel model) {
        ArrayList<BpmnModel> subModels = new ArrayList<BpmnModel>();
        Collection flowElements = model.getMainProcess().getFlowElements();
        HashMap<String, GraphicInfo> locations = new HashMap<String, GraphicInfo>();
        HashMap<String, List<GraphicInfo>> flowLocations = new HashMap<String, List<GraphicInfo>>();
        HashMap<String, GraphicInfo> labelLocations = new HashMap<String, GraphicInfo>();
        locations.putAll(model.getLocationMap());
        flowLocations.putAll(model.getFlowLocationMap());
        labelLocations.putAll(model.getLabelLocationMap());
        BpmnModel mainModel = new BpmnModel();
        mainModel.addProcess(model.getMainProcess());
        String elementId = null;
        for (FlowElement element : flowElements) {
            elementId = element.getId();
            if (element instanceof SubProcess) {
                subModels.addAll(this.parseSubModels(element, locations, flowLocations, labelLocations));
            }
            if (element instanceof SequenceFlow && null != flowLocations.get(elementId)) {
                mainModel.getFlowLocationMap().put(elementId, flowLocations.get(elementId));
            } else if (!(element instanceof DataObject) && null != locations.get(elementId)) {
                mainModel.getLocationMap().put(elementId, locations.get(elementId));
            }
            if (null == labelLocations.get(elementId)) continue;
            mainModel.getLabelLocationMap().put(elementId, labelLocations.get(elementId));
        }
        subModels.add(mainModel);
        return subModels;
    }

    private List<BpmnModel> parseSubModels(FlowElement subElement, Map<String, GraphicInfo> locations, Map<String, List<GraphicInfo>> flowLocations, Map<String, GraphicInfo> labelLocations) {
        ArrayList<BpmnModel> subModels = new ArrayList<BpmnModel>();
        BpmnModel subModel = new BpmnModel();
        String elementId = null;
        Collection subFlowElements = ((SubProcess)subElement).getFlowElements();
        Process newMainProcess = new Process();
        newMainProcess.setId(subElement.getId());
        newMainProcess.getFlowElements().addAll(subFlowElements);
        newMainProcess.getArtifacts().addAll(((SubProcess)subElement).getArtifacts());
        subModel.addProcess(newMainProcess);
        for (FlowElement element : subFlowElements) {
            elementId = element.getId();
            if (element instanceof SubProcess) {
                subModels.addAll(this.parseSubModels(element, locations, flowLocations, labelLocations));
            }
            if (element instanceof SequenceFlow && null != flowLocations.get(elementId)) {
                subModel.getFlowLocationMap().put(elementId, flowLocations.get(elementId));
            } else if (!(element instanceof DataObject) && null != locations.get(elementId)) {
                subModel.getLocationMap().put(elementId, locations.get(elementId));
            }
            if (null == labelLocations.get(elementId)) continue;
            subModel.getLabelLocationMap().put(elementId, labelLocations.get(elementId));
        }
        subModels.add(subModel);
        return subModels;
    }
}

