/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.flowable.bpmn.converter.child.BaseChildElementParser;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.MultiInstanceLoopCharacteristics;

public class MultiInstanceParser
extends BaseChildElementParser {
    @Override
    public String getElementName() {
        return "multiInstanceLoopCharacteristics";
    }

    @Override
    public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
        if (!(parentElement instanceof Activity)) {
            return;
        }
        MultiInstanceLoopCharacteristics multiInstanceDef = new MultiInstanceLoopCharacteristics();
        BpmnXMLUtil.addXMLLocation((BaseElement)multiInstanceDef, xtr);
        if (xtr.getAttributeValue(null, "isSequential") != null) {
            multiInstanceDef.setSequential(Boolean.valueOf(xtr.getAttributeValue(null, "isSequential")).booleanValue());
        }
        multiInstanceDef.setInputDataItem(BpmnXMLUtil.getAttributeValue("collection", xtr));
        multiInstanceDef.setElementVariable(BpmnXMLUtil.getAttributeValue("elementVariable", xtr));
        multiInstanceDef.setElementIndexVariable(BpmnXMLUtil.getAttributeValue("elementIndexVariable", xtr));
        boolean readyWithMultiInstance = false;
        try {
            while (!readyWithMultiInstance && xtr.hasNext()) {
                xtr.next();
                if (xtr.isStartElement() && "loopCardinality".equalsIgnoreCase(xtr.getLocalName())) {
                    multiInstanceDef.setLoopCardinality(xtr.getElementText());
                    continue;
                }
                if (xtr.isStartElement() && "loopDataInputRef".equalsIgnoreCase(xtr.getLocalName())) {
                    multiInstanceDef.setInputDataItem(xtr.getElementText());
                    continue;
                }
                if (xtr.isStartElement() && "inputDataItem".equalsIgnoreCase(xtr.getLocalName())) {
                    if (xtr.getAttributeValue(null, "name") == null) continue;
                    multiInstanceDef.setElementVariable(xtr.getAttributeValue(null, "name"));
                    continue;
                }
                if (xtr.isStartElement() && "completionCondition".equalsIgnoreCase(xtr.getLocalName())) {
                    multiInstanceDef.setCompletionCondition(xtr.getElementText());
                    continue;
                }
                if (!xtr.isEndElement() || !this.getElementName().equalsIgnoreCase(xtr.getLocalName())) continue;
                readyWithMultiInstance = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing multi instance definition", (Throwable)e);
        }
        ((Activity)parentElement).setLoopCharacteristics(multiInstanceDef);
    }
}

