/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.export;

import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.constants.BpmnXMLConstants;
import org.flowable.bpmn.converter.export.FlowableListenerExport;
import org.flowable.bpmn.converter.export.LaneExport;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.ExtensionAttribute;
import org.flowable.bpmn.model.Process;

public class ProcessExport
implements BpmnXMLConstants {
    public static final List<ExtensionAttribute> defaultProcessAttributes = Arrays.asList(new ExtensionAttribute("id"), new ExtensionAttribute("name"), new ExtensionAttribute("isExecutable"), new ExtensionAttribute("candidateStarterUsers"), new ExtensionAttribute("candidateStarterGroups"));

    public static void writeProcess(Process process, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("process");
        xtw.writeAttribute("id", process.getId());
        if (StringUtils.isNotEmpty((CharSequence)process.getName())) {
            xtw.writeAttribute("name", process.getName());
        }
        xtw.writeAttribute("isExecutable", Boolean.toString(process.isExecutable()));
        if (!process.getCandidateStarterUsers().isEmpty()) {
            xtw.writeAttribute("flowable", "http://flowable.org/bpmn", "candidateStarterUsers", BpmnXMLUtil.convertToDelimitedString(process.getCandidateStarterUsers()));
        }
        if (!process.getCandidateStarterGroups().isEmpty()) {
            xtw.writeAttribute("flowable", "http://flowable.org/bpmn", "candidateStarterGroups", BpmnXMLUtil.convertToDelimitedString(process.getCandidateStarterGroups()));
        }
        BpmnXMLUtil.writeCustomAttributes(process.getAttributes().values(), xtw, defaultProcessAttributes);
        if (StringUtils.isNotEmpty((CharSequence)process.getDocumentation())) {
            xtw.writeStartElement("documentation");
            xtw.writeCharacters(process.getDocumentation());
            xtw.writeEndElement();
        }
        boolean didWriteExtensionStartElement = FlowableListenerExport.writeListeners((BaseElement)process, false, xtw);
        if (didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)process, didWriteExtensionStartElement, xtw)) {
            xtw.writeEndElement();
        }
        LaneExport.writeLanes(process, xtw);
    }
}

