/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.BaseBpmnXMLConverter;
import org.flowable.bpmn.converter.child.BaseChildElementParser;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.IOParameter;

public class CallActivityXMLConverter
extends BaseBpmnXMLConverter {
    protected Map<String, BaseChildElementParser> childParserMap = new HashMap<String, BaseChildElementParser>();

    public CallActivityXMLConverter() {
        InParameterParser inParameterParser = new InParameterParser();
        this.childParserMap.put(inParameterParser.getElementName(), inParameterParser);
        OutParameterParser outParameterParser = new OutParameterParser();
        this.childParserMap.put(outParameterParser.getElementName(), outParameterParser);
    }

    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return CallActivity.class;
    }

    @Override
    protected String getXMLElementName() {
        return "callActivity";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        CallActivity callActivity = new CallActivity();
        BpmnXMLUtil.addXMLLocation((BaseElement)callActivity, xtr);
        callActivity.setCalledElement(xtr.getAttributeValue(null, "calledElement"));
        callActivity.setProcessInstanceName(BpmnXMLUtil.getAttributeValue("processInstanceName", xtr));
        callActivity.setBusinessKey(BpmnXMLUtil.getAttributeValue("businessKey", xtr));
        callActivity.setInheritBusinessKey(Boolean.parseBoolean(BpmnXMLUtil.getAttributeValue("inheritBusinessKey", xtr)));
        callActivity.setInheritVariables(Boolean.valueOf(BpmnXMLUtil.getAttributeValue("inheritVariables", xtr)).booleanValue());
        callActivity.setSameDeployment(Boolean.valueOf(BpmnXMLUtil.getAttributeValue("sameDeployment", xtr)).booleanValue());
        callActivity.setUseLocalScopeForOutParameters(Boolean.valueOf(BpmnXMLUtil.getAttributeValue("useLocalScopeForOutParameters", xtr)).booleanValue());
        this.parseChildElements(this.getXMLElementName(), (BaseElement)callActivity, this.childParserMap, model, xtr);
        return callActivity;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        CallActivity callActivity = (CallActivity)element;
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getCalledElement())) {
            xtw.writeAttribute("calledElement", callActivity.getCalledElement());
        }
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getProcessInstanceName())) {
            this.writeQualifiedAttribute("processInstanceName", callActivity.getProcessInstanceName(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getBusinessKey())) {
            this.writeQualifiedAttribute("businessKey", callActivity.getBusinessKey(), xtw);
        }
        if (callActivity.isInheritBusinessKey()) {
            this.writeQualifiedAttribute("inheritBusinessKey", "true", xtw);
        }
        if (callActivity.isUseLocalScopeForOutParameters()) {
            this.writeQualifiedAttribute("useLocalScopeForOutParameters", "true", xtw);
        }
        if (callActivity.isInheritVariables()) {
            this.writeQualifiedAttribute("inheritVariables", "true", xtw);
        }
        if (callActivity.isSameDeployment()) {
            this.writeQualifiedAttribute("sameDeployment", "true", xtw);
        }
    }

    @Override
    protected boolean writeExtensionChildElements(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        CallActivity callActivity = (CallActivity)element;
        didWriteExtensionStartElement = this.writeIOParameters("in", callActivity.getInParameters(), didWriteExtensionStartElement, xtw);
        didWriteExtensionStartElement = this.writeIOParameters("out", callActivity.getOutParameters(), didWriteExtensionStartElement, xtw);
        return didWriteExtensionStartElement;
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
    }

    private boolean writeIOParameters(String elementName, List<IOParameter> parameterList, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        if (parameterList.isEmpty()) {
            return didWriteExtensionStartElement;
        }
        for (IOParameter ioParameter : parameterList) {
            if (!didWriteExtensionStartElement) {
                xtw.writeStartElement("extensionElements");
                didWriteExtensionStartElement = true;
            }
            xtw.writeStartElement("flowable", elementName, "http://flowable.org/bpmn");
            if (StringUtils.isNotEmpty((CharSequence)ioParameter.getSource())) {
                this.writeDefaultAttribute("source", ioParameter.getSource(), xtw);
            }
            if (StringUtils.isNotEmpty((CharSequence)ioParameter.getSourceExpression())) {
                this.writeDefaultAttribute("sourceExpression", ioParameter.getSourceExpression(), xtw);
            }
            if (StringUtils.isNotEmpty((CharSequence)ioParameter.getTarget())) {
                this.writeDefaultAttribute("target", ioParameter.getTarget(), xtw);
            }
            xtw.writeEndElement();
        }
        return didWriteExtensionStartElement;
    }

    public class OutParameterParser
    extends BaseChildElementParser {
        @Override
        public String getElementName() {
            return "out";
        }

        @Override
        public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
            String source = xtr.getAttributeValue(null, "source");
            String sourceExpression = xtr.getAttributeValue(null, "sourceExpression");
            String target = xtr.getAttributeValue(null, "target");
            if ((StringUtils.isNotEmpty((CharSequence)source) || StringUtils.isNotEmpty((CharSequence)sourceExpression)) && StringUtils.isNotEmpty((CharSequence)target)) {
                IOParameter parameter = new IOParameter();
                if (StringUtils.isNotEmpty((CharSequence)sourceExpression)) {
                    parameter.setSourceExpression(sourceExpression);
                } else {
                    parameter.setSource(source);
                }
                parameter.setTarget(target);
                ((CallActivity)parentElement).getOutParameters().add(parameter);
            }
        }
    }

    public class InParameterParser
    extends BaseChildElementParser {
        @Override
        public String getElementName() {
            return "in";
        }

        @Override
        public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
            String source = xtr.getAttributeValue(null, "source");
            String sourceExpression = xtr.getAttributeValue(null, "sourceExpression");
            String target = xtr.getAttributeValue(null, "target");
            if ((StringUtils.isNotEmpty((CharSequence)source) || StringUtils.isNotEmpty((CharSequence)sourceExpression)) && StringUtils.isNotEmpty((CharSequence)target)) {
                IOParameter parameter = new IOParameter();
                if (StringUtils.isNotEmpty((CharSequence)sourceExpression)) {
                    parameter.setSourceExpression(sourceExpression);
                } else {
                    parameter.setSource(source);
                }
                parameter.setTarget(target);
                ((CallActivity)parentElement).getInParameters().add(parameter);
            }
        }
    }
}

