/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.export;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.constants.BpmnXMLConstants;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ExtensionAttribute;

public class DefinitionsRootExport
implements BpmnXMLConstants {
    protected static final Set<String> defaultNamespaces = new HashSet<String>(Arrays.asList("xsi", "xsd", "flowable", "bpmndi", "omgdc", "omgdi"));
    protected static final List<ExtensionAttribute> defaultAttributes = Arrays.asList(new ExtensionAttribute("typeLanguage"), new ExtensionAttribute("expressionLanguage"), new ExtensionAttribute("targetNamespace"));

    public static void writeRootElement(BpmnModel model, XMLStreamWriter xtw, String encoding) throws Exception {
        xtw.writeStartDocument(encoding, "1.0");
        xtw.writeStartElement("definitions");
        xtw.setDefaultNamespace("http://www.omg.org/spec/BPMN/20100524/MODEL");
        xtw.writeDefaultNamespace("http://www.omg.org/spec/BPMN/20100524/MODEL");
        xtw.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xtw.writeNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        xtw.writeNamespace("flowable", "http://flowable.org/bpmn");
        xtw.writeNamespace("bpmndi", "http://www.omg.org/spec/BPMN/20100524/DI");
        xtw.writeNamespace("omgdc", "http://www.omg.org/spec/DD/20100524/DC");
        xtw.writeNamespace("omgdi", "http://www.omg.org/spec/DD/20100524/DI");
        for (String prefix : model.getNamespaces().keySet()) {
            if (defaultNamespaces.contains(prefix) || !StringUtils.isNotEmpty((CharSequence)prefix)) continue;
            xtw.writeNamespace(prefix, (String)model.getNamespaces().get(prefix));
        }
        xtw.writeAttribute("typeLanguage", "http://www.w3.org/2001/XMLSchema");
        xtw.writeAttribute("expressionLanguage", "http://www.w3.org/1999/XPath");
        if (StringUtils.isNotEmpty((CharSequence)model.getTargetNamespace())) {
            xtw.writeAttribute("targetNamespace", model.getTargetNamespace());
        } else {
            xtw.writeAttribute("targetNamespace", "http://www.flowable.org/test");
        }
        BpmnXMLUtil.writeCustomAttributes(model.getDefinitionsAttributes().values(), xtw, model.getNamespaces(), defaultAttributes);
    }
}

