/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.camel;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultProducer;
import org.flowable.camel.ExchangeUtils;
import org.flowable.camel.FlowableEndpoint;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.IdentityService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;

public class FlowableProducer
extends DefaultProducer {
    protected IdentityService identityService;
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;
    protected ManagementService managementService;
    public static final String PROCESS_KEY_PROPERTY = "PROCESS_KEY_PROPERTY";
    public static final String PROCESS_ID_PROPERTY = "PROCESS_ID_PROPERTY";
    public static final String EXECUTION_ID_PROPERTY = "EXECUTION_ID_PROPERTY";
    private final long timeout;
    private final long timeResolution;
    private String processKey;
    private String activity;

    public FlowableProducer(FlowableEndpoint endpoint, long timeout, long timeResolution) {
        super((Endpoint)endpoint);
        String[] path = endpoint.getEndpointKey().split(":");
        this.processKey = path[1].replace("//", "");
        if (path.length > 2) {
            this.activity = path[2];
        }
        this.timeout = timeout;
        this.timeResolution = timeResolution;
    }

    public void process(Exchange exchange) throws Exception {
        if (this.shouldStartProcess()) {
            ProcessInstance pi = this.startProcess(exchange);
            this.copyResultToCamel(exchange, pi);
        } else {
            this.signal(exchange);
        }
    }

    protected void copyResultToCamel(Exchange exchange, ProcessInstance pi) {
        exchange.setProperty(PROCESS_ID_PROPERTY, (Object)pi.getProcessInstanceId());
        Map<String, Object> returnVars = this.getFlowableEndpoint().getReturnVarMap();
        if (returnVars != null && returnVars.size() > 0) {
            Map processVariables = null;
            processVariables = this.repositoryService.isFlowable5ProcessDefinition(pi.getProcessDefinitionId()) != false ? (Map)this.managementService.executeCommand(commandContext -> {
                Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                return compatibilityHandler.getVariables(pi);
            }) : ((ExecutionEntity)pi).getVariables();
            if (processVariables != null) {
                for (String variableName : returnVars.keySet()) {
                    if (!processVariables.containsKey(variableName)) continue;
                    exchange.setProperty(variableName, processVariables.get(variableName));
                }
            }
        }
    }

    protected boolean shouldStartProcess() {
        return this.activity == null;
    }

    protected void signal(Exchange exchange) {
        String processInstanceId = this.findProcessInstanceId(exchange);
        String executionId = (String)exchange.getProperty(EXECUTION_ID_PROPERTY, String.class);
        boolean firstTime = true;
        long initialTime = System.currentTimeMillis();
        Execution execution = null;
        while (firstTime || this.timeout > 0L && System.currentTimeMillis() - initialTime < this.timeout) {
            try {
                Thread.sleep(this.timeResolution);
            }
            catch (InterruptedException e) {
                throw new FlowableException("error occurred while waiting for activity=" + this.activity + " for processInstanceId=" + processInstanceId, (Throwable)e);
            }
            firstTime = false;
            execution = executionId != null ? (Execution)this.runtimeService.createExecutionQuery().executionId(executionId).activityId(this.activity).singleResult() : (Execution)this.runtimeService.createExecutionQuery().processDefinitionKey(this.processKey).processInstanceId(processInstanceId).activityId(this.activity).singleResult();
            if (execution == null) continue;
        }
        if (execution == null) {
            throw new FlowableException("Could not find activity " + this.activity + " for processId " + processInstanceId + " in defined timeout of " + this.timeout + " ms.");
        }
        this.runtimeService.setVariables(execution.getId(), ExchangeUtils.prepareVariables(exchange, this.getFlowableEndpoint()));
        this.runtimeService.trigger(execution.getId());
    }

    protected String findProcessInstanceId(Exchange exchange) {
        String processInstanceId = (String)exchange.getProperty(PROCESS_ID_PROPERTY, String.class);
        if (processInstanceId != null) {
            return processInstanceId;
        }
        String key = (String)exchange.getProperty(PROCESS_KEY_PROPERTY, String.class);
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(key).singleResult();
        if (processInstance == null) {
            throw new FlowableException("Could not start process instance with business key " + key);
        }
        return processInstance.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProcessInstance startProcess(Exchange exchange) {
        FlowableEndpoint endpoint = this.getFlowableEndpoint();
        String key = (String)exchange.getProperty(PROCESS_KEY_PROPERTY, String.class);
        try {
            if (endpoint.isSetProcessInitiator()) {
                this.setProcessInitiator(ExchangeUtils.prepareInitiator(exchange, endpoint));
            }
            if (key == null) {
                ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(this.processKey, ExchangeUtils.prepareVariables(exchange, endpoint));
                return processInstance;
            }
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(this.processKey, key, ExchangeUtils.prepareVariables(exchange, endpoint));
            return processInstance;
        }
        finally {
            if (endpoint.isSetProcessInitiator()) {
                this.setProcessInitiator(null);
            }
        }
    }

    protected void setProcessInitiator(String processInitiator) {
        if (this.identityService == null) {
            throw new FlowableException("IdentityService is missing and must be provided to set process initiator.");
        }
        this.identityService.setAuthenticatedUserId(processInitiator);
    }

    protected FlowableEndpoint getFlowableEndpoint() {
        return (FlowableEndpoint)this.getEndpoint();
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public void setRuntimeService(RuntimeService runtimeService) {
        this.runtimeService = runtimeService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setManagementService(ManagementService managementService) {
        this.managementService = managementService;
    }
}

