/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.camel;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.PropertiesHelper;
import org.flowable.camel.FlowableEndpoint;
import org.flowable.engine.IdentityService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;

public class FlowableComponent
extends DefaultComponent {
    protected IdentityService identityService;
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;
    protected ManagementService managementService;
    protected boolean copyVariablesToProperties;
    protected boolean copyVariablesToBodyAsMap;
    protected boolean copyCamelBodyToBody;

    public void setCamelContext(CamelContext context) {
        super.setCamelContext(context);
        this.identityService = this.getByType(context, IdentityService.class);
        this.runtimeService = this.getByType(context, RuntimeService.class);
        this.repositoryService = this.getByType(context, RepositoryService.class);
        this.managementService = this.getByType(context, ManagementService.class);
    }

    private <T> T getByType(CamelContext ctx, Class<T> kls) {
        Map looked = ctx.getRegistry().findByTypeWithName(kls);
        if (looked.isEmpty()) {
            return null;
        }
        return (T)looked.values().iterator().next();
    }

    protected Endpoint createEndpoint(String s, String s1, Map<String, Object> parameters) throws Exception {
        FlowableEndpoint ae = new FlowableEndpoint(s, this.getCamelContext());
        ae.setComponent((Component)this);
        ae.setIdentityService(this.identityService);
        ae.setRuntimeService(this.runtimeService);
        ae.setRepositoryService(this.repositoryService);
        ae.setManagementService(this.managementService);
        ae.setCopyVariablesToProperties(this.copyVariablesToProperties);
        ae.setCopyVariablesToBodyAsMap(this.copyVariablesToBodyAsMap);
        ae.setCopyCamelBodyToBody(this.copyCamelBodyToBody);
        Map returnVars = PropertiesHelper.extractProperties(parameters, (String)"var.return.");
        if (returnVars != null && returnVars.size() > 0) {
            ae.getReturnVarMap().putAll(returnVars);
        }
        return ae;
    }

    public boolean isCopyVariablesToProperties() {
        return this.copyVariablesToProperties;
    }

    public void setCopyVariablesToProperties(boolean copyVariablesToProperties) {
        this.copyVariablesToProperties = copyVariablesToProperties;
    }

    public boolean isCopyCamelBodyToBody() {
        return this.copyCamelBodyToBody;
    }

    public void setCopyCamelBodyToBody(boolean copyCamelBodyToBody) {
        this.copyCamelBodyToBody = copyCamelBodyToBody;
    }

    public boolean isCopyVariablesToBodyAsMap() {
        return this.copyVariablesToBodyAsMap;
    }

    public void setCopyVariablesToBodyAsMap(boolean copyVariablesToBodyAsMap) {
        this.copyVariablesToBodyAsMap = copyVariablesToBodyAsMap;
    }
}

