/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter;

import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.BaseCmmnXmlConverter;
import org.flowable.cmmn.converter.CmmnXMLException;
import org.flowable.cmmn.converter.ConversionHelper;
import org.flowable.cmmn.model.CmmnElement;

public class DocumentationXmlConverter
extends BaseCmmnXmlConverter {
    @Override
    public String getXMLElementName() {
        return "documentation";
    }

    @Override
    public boolean isCmmnElement() {
        return false;
    }

    protected CmmnElement convert(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        try {
            String documentation;
            String textFormat = xtr.getAttributeValue(null, "textFormat");
            if (StringUtils.isEmpty((CharSequence)textFormat)) {
                textFormat = "text/plain";
            }
            if (StringUtils.isNotEmpty((CharSequence)(documentation = xtr.getElementText()))) {
                conversionHelper.getCurrentCmmnElement().setDocumentation(documentation);
                conversionHelper.getCurrentCmmnElement().setDocumentationTextFormat(textFormat);
            }
            return null;
        }
        catch (Exception e) {
            throw new CmmnXMLException("Error reading documentation element", e);
        }
    }
}

