/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter;

import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.BaseCmmnXmlConverter;
import org.flowable.cmmn.converter.ConversionHelper;
import org.flowable.cmmn.model.CmmnElement;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.cmmn.model.ServiceTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldExtensionXmlConverter
extends BaseCmmnXmlConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldExtensionXmlConverter.class);

    @Override
    public String getXMLElementName() {
        return "field";
    }

    @Override
    public boolean isCmmnElement() {
        return false;
    }

    protected CmmnElement convert(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        CmmnElement cmmnElement = conversionHelper.getCurrentCmmnElement();
        if (!(cmmnElement instanceof ServiceTask)) {
            return null;
        }
        ServiceTask serviceTask = (ServiceTask)cmmnElement;
        FieldExtension extension = new FieldExtension();
        extension.setFieldName(xtr.getAttributeValue(null, "name"));
        String stringValueAttribute = xtr.getAttributeValue(null, "stringValue");
        String expressionAttribute = xtr.getAttributeValue(null, "expression");
        if (StringUtils.isNotEmpty((CharSequence)stringValueAttribute)) {
            extension.setStringValue(stringValueAttribute);
        } else if (StringUtils.isNotEmpty((CharSequence)expressionAttribute)) {
            extension.setExpression(expressionAttribute);
        } else {
            boolean readyWithFieldExtension = false;
            try {
                while (!readyWithFieldExtension && xtr.hasNext()) {
                    xtr.next();
                    if (xtr.isStartElement() && "string".equalsIgnoreCase(xtr.getLocalName())) {
                        extension.setStringValue(xtr.getElementText().trim());
                        continue;
                    }
                    if (xtr.isStartElement() && "expression".equalsIgnoreCase(xtr.getLocalName())) {
                        extension.setExpression(xtr.getElementText().trim());
                        continue;
                    }
                    if (!xtr.isEndElement() || !this.getXMLElementName().equalsIgnoreCase(xtr.getLocalName())) continue;
                    readyWithFieldExtension = true;
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error parsing field extension child elements", (Throwable)e);
            }
        }
        serviceTask.getFieldExtensions().add(extension);
        return null;
    }
}

