/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.export.AbstractPlanItemDefinitionExport;
import org.flowable.cmmn.model.HumanTask;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Task;

public class HumanTaskExport
extends AbstractPlanItemDefinitionExport {
    public static void writeHumanTask(HumanTask humanTask, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("humanTask");
        HumanTaskExport.writeCommonPlanItemDefinitionAttributes((PlanItemDefinition)humanTask, xtw);
        HumanTaskExport.writeBlockingAttribute(xtw, (Task)humanTask);
        if (StringUtils.isNotEmpty((CharSequence)humanTask.getAssignee())) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "assignee", humanTask.getAssignee());
        }
        if (StringUtils.isNotEmpty((CharSequence)humanTask.getOwner())) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "owner", humanTask.getOwner());
        }
        if (humanTask.getCandidateUsers() != null && humanTask.getCandidateUsers().size() > 0) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "candidateUsers", HumanTaskExport.convertListToCommaSeparatedString(humanTask.getCandidateUsers()));
        }
        if (humanTask.getCandidateGroups() != null && humanTask.getCandidateGroups().size() > 0) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "candidateGroups", HumanTaskExport.convertListToCommaSeparatedString(humanTask.getCandidateGroups()));
        }
        if (StringUtils.isNotEmpty((CharSequence)humanTask.getFormKey())) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "formKey", humanTask.getFormKey());
        }
        xtw.writeEndElement();
    }

    protected static String convertListToCommaSeparatedString(List<String> values) {
        StringBuilder valueBuilder = new StringBuilder();
        for (String value : values) {
            if (valueBuilder.length() > 0) {
                valueBuilder.append(",");
            }
            valueBuilder.append(value);
        }
        return valueBuilder.toString();
    }
}

